/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.cookie;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        return CookieUtils.getCookieValue(request, cookieName, null);
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName, String charset) {
        Cookie[] cookieList = request.getCookies();
        if (cookieList == null || cookieName == null) {
            return null;
        }
        String retValue = null;
        try {
            for (int i = 0; i < cookieList.length; ++i) {
                if (!cookieList[i].getName().equals(cookieName)) continue;
                retValue = charset != null && charset.length() > 0 ? URLDecoder.decode(cookieList[i].getValue(), charset) : cookieList[i].getValue();
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cookie Decode Error.", (Throwable)e);
        }
        return retValue;
    }

    public static CookieBuilder newCookieBuilder() {
        return new CookieBuilder();
    }

    public static void deleteCookie(String cookieName, String domain, HttpServletResponse response) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setDomain(domain);
        response.addCookie(cookie);
    }

    public static class CookieBuilder {
        private HttpServletRequest request;
        private HttpServletResponse response;
        private Integer maxAge;
        private String charset;
        private boolean httpOnly = false;
        private String domain;
        private String path = "/";
        private String name;
        private String value;

        public CookieBuilder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public CookieBuilder response(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public CookieBuilder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public CookieBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public CookieBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public CookieBuilder path(String path) {
            this.path = path;
            return this;
        }

        public CookieBuilder value(String value) {
            this.value = value;
            return this;
        }

        public CookieBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CookieBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public void build() {
            try {
                if (StringUtils.isEmpty((Object)this.charset)) {
                    this.charset = "utf-8";
                }
                if (StringUtils.isEmpty((Object)this.name) || StringUtils.isEmpty((Object)this.value)) {
                    throw new RuntimeException("cookie\u540d\u79f0\u548c\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)this.charset)) {
                    this.value = URLEncoder.encode(this.value, this.charset);
                }
                Cookie cookie = new Cookie(this.name, this.value);
                if (this.maxAge != null && this.maxAge >= 0) {
                    cookie.setMaxAge(this.maxAge.intValue());
                }
                if (!StringUtils.isEmpty((Object)this.domain)) {
                    cookie.setDomain(this.domain);
                } else if (null != this.request) {
                    cookie.setDomain(this.getDomainName(this.request));
                }
                cookie.setPath("/");
                if (!StringUtils.isEmpty((Object)this.path)) {
                    cookie.setPath(this.path);
                }
                cookie.setHttpOnly(this.httpOnly);
                this.response.addCookie(cookie);
            }
            catch (Exception e) {
                log.error("Cookie Encode Error.", (Throwable)e);
            }
        }

        private String getDomainName(HttpServletRequest request) {
            String domainName = null;
            String serverName = request.getRequestURL().toString();
            if (serverName == null || serverName.equals("")) {
                domainName = "";
            } else {
                serverName = serverName.toLowerCase();
                serverName = serverName.substring(7);
                int end = serverName.indexOf("/");
                String[] domains = (serverName = serverName.substring(0, end)).split("\\.");
                int len = domains.length;
                domainName = len > 3 ? domains[len - 3] + "." + domains[len - 2] + "." + domains[len - 1] : (len <= 3 && len > 1 ? domains[len - 2] + "." + domains[len - 1] : serverName);
            }
            if (domainName != null && domainName.indexOf(":") > 0) {
                String[] ary = domainName.split("\\:");
                domainName = ary[0];
            }
            return domainName;
        }
    }
}

