/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.call;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ApiCallUtils {
    public static String doGetResJson(String url) {
        RestTemplate restTemplate = new RestTemplate();
        String result = (String)restTemplate.getForObject(url, String.class, new Object[0]);
        return result;
    }

    public static <T> T doGetResPojo(String url, Class<T> target) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.getForEntity(url, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> String doGetJsonResJson(String url, T source) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, jsonData, String.class, new Object[0]);
        return (String)result.getBody();
    }

    public static <T> T doGetJsonResPojo(String url, T source, Class<T> target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, jsonData, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> T doPostJsonResPojo(String url, T source, Class<T> target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.postForEntity(url, jsonData, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> String doPostJsonResJson(String url, T source) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        String result = (String)restTemplate.postForObject(url, jsonData, String.class, new Object[0]);
        return result;
    }

    public static <T> T doPostPojoResPojo(String url, T source, Class<T> target) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.postForEntity(url, source, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> String doPostPojoResJson(String url, T source) {
        RestTemplate restTemplate = new RestTemplate();
        String result = (String)restTemplate.postForObject(url, source, String.class, new Object[0]);
        return result;
    }

    public static <T> T doPutJsonResPojo(String url, T source, Class<T> target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.PUT, jsonData, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> String doPutJsonResJson(String url, T target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(target);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.PUT, jsonData, String.class, new Object[0]);
        return (String)result.getBody();
    }

    public static <T> T doDeleteJsonResPojo(String url, T source, Class<T> target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(source);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.DELETE, jsonData, target, new Object[0]);
        return (T)result.getBody();
    }

    public static <T> String doDeleteJsonResJson(String url, T target) {
        HttpEntity<String> jsonData = ApiCallUtils.toJson(target);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.DELETE, jsonData, String.class, new Object[0]);
        return (String)result.getBody();
    }

    private static <T> HttpEntity<String> toJson(T source) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonStr = "";
        try {
            jsonStr = mapper.writeValueAsString(source);
        }
        catch (JsonProcessingException e) {
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity jsonData = new HttpEntity((Object)jsonStr, (MultiValueMap)headers);
        return jsonData;
    }
}

