/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.utils.bean;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanHelper {
    private static final Logger log = LoggerFactory.getLogger(BeanHelper.class);

    public static <T> T copyProperties(Object source, Class<T> target) {
        try {
            T t = target.newInstance();
            BeanUtils.copyProperties((Object)source, t);
            return t;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u76ee\u6807\u5bf9\u8c61{}\u6784\u9020\u51fd\u6570\u5f02\u5e38", (Object)target.getName(), (Object)e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }

    public static <T> List<T> copyWithCollection(List<?> sourceList, Class<T> target) {
        try {
            return sourceList.stream().map(s -> BeanHelper.copyProperties(s, target)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u76ee\u6807\u5bf9\u8c61{}\u6784\u9020\u51fd\u6570\u5f02\u5e38", (Object)target.getName(), (Object)e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }

    public static <T> Set<T> copyWithCollection(Set<?> sourceList, Class<T> target) {
        try {
            return sourceList.stream().map(s -> BeanHelper.copyProperties(s, target)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u76ee\u6807\u5bf9\u8c61{}\u6784\u9020\u51fd\u6570\u5f02\u5e38", (Object)target.getName(), (Object)e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }
}

