/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.exception;

import cn.lonelysnow.common.exception.BaseExceptionEnum;
import org.joda.time.DateTime;

public class SnowException
extends RuntimeException {
    private Integer httpCode;
    private Integer errCode;
    private String timeStamp;

    public SnowException() {
    }

    public SnowException(Integer httpCode, Integer errCode, String message) {
        super(message);
        this.httpCode = httpCode;
        this.errCode = errCode;
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(BaseExceptionEnum em) {
        super(em.getMessage());
        this.httpCode = em.getHttpCode();
        this.errCode = em.getErrCode();
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(Integer httpCode, Integer errCode, String message, Throwable cause) {
        super(message, cause);
        this.httpCode = httpCode;
        this.errCode = errCode;
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(BaseExceptionEnum em, Throwable cause) {
        super(em.getMessage(), cause);
        this.httpCode = em.getHttpCode();
        this.errCode = em.getErrCode();
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public Integer getHttpCode() {
        return this.httpCode;
    }

    public Integer getErrCode() {
        return this.errCode;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setHttpCode(Integer httpCode) {
        this.httpCode = httpCode;
    }

    public void setErrCode(Integer errCode) {
        this.errCode = errCode;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowException)) {
            return false;
        }
        SnowException other = (SnowException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$httpCode = this.getHttpCode();
        Integer other$httpCode = other.getHttpCode();
        if (this$httpCode == null ? other$httpCode != null : !((Object)this$httpCode).equals(other$httpCode)) {
            return false;
        }
        Integer this$errCode = this.getErrCode();
        Integer other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !((Object)this$errCode).equals(other$errCode)) {
            return false;
        }
        String this$timeStamp = this.getTimeStamp();
        String other$timeStamp = other.getTimeStamp();
        return !(this$timeStamp == null ? other$timeStamp != null : !this$timeStamp.equals(other$timeStamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnowException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $httpCode = this.getHttpCode();
        result = result * 59 + ($httpCode == null ? 43 : ((Object)$httpCode).hashCode());
        Integer $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : ((Object)$errCode).hashCode());
        String $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : $timeStamp.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SnowException(httpCode=" + this.getHttpCode() + ", errCode=" + this.getErrCode() + ", timeStamp=" + this.getTimeStamp() + ")";
    }
}

