/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.exception;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.ExceptionResult;
import cn.lonelysnow.common.exception.SnowException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class BaseExceptionAdvice {
    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ExceptionResult> handleRuntimeException(RuntimeException e) {
        return ResponseEntity.status((int)500).body((Object)new ExceptionResult(e.getMessage()));
    }

    @ExceptionHandler(value={SnowException.class})
    public ResponseEntity<ExceptionResult> handleException(SnowException e) {
        return ResponseEntity.status((int)e.getHttpCode()).body((Object)new ExceptionResult(e));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<ExceptionResult> handleNoHandlerFoundException(NoHandlerFoundException e) {
        return ResponseEntity.status((int)404).body((Object)new ExceptionResult(CommonExceptionEnum.RESOURCE_NOT_FOUND));
    }
}

