/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.auth;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaUtils {
    private static final Logger log = LoggerFactory.getLogger(RsaUtils.class);
    private static final int DEFAULT_KEY_SIZE = 2048;

    public static PublicKey getPublicKey(String filename) {
        byte[] bytes = RsaUtils.readFile(filename);
        return RsaUtils.getPublicKey(bytes);
    }

    public static PrivateKey getPrivateKey(String filename) {
        byte[] bytes = RsaUtils.readFile(filename);
        return RsaUtils.getPrivateKey(bytes);
    }

    private static PublicKey getPublicKey(byte[] bytes) {
        try {
            bytes = Base64.getDecoder().decode(bytes);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u7b97\u6cd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_NO_SUCH_ALGORITHM);
        }
        catch (InvalidKeySpecException e) {
            log.error("\u79d8\u94a5\u5931\u6548\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_INVALID_KEY_SPEC);
        }
    }

    private static PrivateKey getPrivateKey(byte[] bytes) {
        try {
            bytes = Base64.getDecoder().decode(bytes);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u7b97\u6cd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_NO_SUCH_ALGORITHM);
        }
        catch (InvalidKeySpecException e) {
            log.error("\u79d8\u94a5\u5931\u6548\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_INVALID_KEY_SPEC);
        }
    }

    public static void generateKey(String publicKeyFilename, String privateKeyFilename, String secret, int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            SecureRandom secureRandom = new SecureRandom(secret.getBytes());
            keyPairGenerator.initialize(Math.max(keySize, 2048), secureRandom);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            byte[] publicKeyBytes = keyPair.getPublic().getEncoded();
            publicKeyBytes = Base64.getEncoder().encode(publicKeyBytes);
            RsaUtils.writeFile(publicKeyFilename, publicKeyBytes);
            byte[] privateKeyBytes = keyPair.getPrivate().getEncoded();
            privateKeyBytes = Base64.getEncoder().encode(privateKeyBytes);
            RsaUtils.writeFile(privateKeyFilename, privateKeyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u751f\u6210\u79d8\u94a5\uff0c\u7b97\u6cd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_NO_SUCH_ALGORITHM);
        }
    }

    private static byte[] readFile(String fileName) {
        try {
            return Files.readAllBytes(new File(fileName).toPath());
        }
        catch (IOException e) {
            log.error("RSA\u79d8\u94a5\u8bfb\u53d6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_FILE_READ_ERROR);
        }
    }

    private static void writeFile(String destPath, byte[] bytes) {
        try {
            File dest = new File(destPath);
            if (!dest.exists()) {
                dest.createNewFile();
            }
            Files.write(dest.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("RSA\u79d8\u94a5\u6587\u4ef6\u521b\u5efa\u6216\u5199\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.RSA_FILE_READ_ERROR);
        }
    }

    public static void main(String[] args) {
        String publicKeyName = "~/rsa/key/id_rsa.pub";
        String privateKeyName = "~/rsa/key/id_rsa";
        RsaUtils.generateKey(publicKeyName, privateKeyName, "LonelySnow", 0);
        PublicKey publicKey = RsaUtils.getPublicKey(publicKeyName);
        System.out.println(publicKey);
        PrivateKey privateKey = RsaUtils.getPrivateKey(privateKeyName);
        System.out.println(privateKey);
    }
}

