/*
 * Decompiled with CFR 0.152.
 */
package cn.lonelysnow.common.auth;

import cn.lonelysnow.common.auth.RsaUtils;
import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import cn.lonelysnow.common.utils.json.JacksonUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private static final String JWT_PAYLOAD_USER_KEY = "user";
    private static final String JWT_PAYLOAD_SUBJECT_VALUE = "LonelySnow";
    private static final Long JWT_DEFAULT_EXPIRATION_TIME = 3600000L;
    private static final String JWT_DEFAULT_SIGN_KEY = "882d12d5d76d6e0ee3c7d0c076f76ddf9cd04863030c4906d5e2d8711b2fa128";

    public static String generateTokenExpireInMinutes(Object userInfo, PrivateKey privateKey, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusMinutes(expire).toDate()).signWith((Key)privateKey, SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpireInSeconds(Object userInfo, PrivateKey privateKey, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusSeconds(expire).toDate()).signWith((Key)privateKey, SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo, PrivateKey privateKey, Long expire) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + expire;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)privateKey, SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo, PrivateKey privateKey) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + JWT_DEFAULT_EXPIRATION_TIME;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)privateKey, SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpireInMinutes(Object userInfo, String keys, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusMinutes(expire).toDate()).signWith((Key)Keys.hmacShaKeyFor((byte[])keys.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (InvalidKeyException e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0cJWT\u79d8\u94a5\u590d\u6742\u5ea6\u672a\u8fbe\u6807\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_SIGN_KEY_ERROR);
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpireInSeconds(Object userInfo, String keys, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusSeconds(expire).toDate()).signWith((Key)Keys.hmacShaKeyFor((byte[])keys.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (InvalidKeyException e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0cJWT\u79d8\u94a5\u590d\u6742\u5ea6\u672a\u8fbe\u6807\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_SIGN_KEY_ERROR);
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo, String keys, Long expire) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + expire;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)Keys.hmacShaKeyFor((byte[])keys.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (InvalidKeyException e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0cJWT\u79d8\u94a5\u590d\u6742\u5ea6\u672a\u8fbe\u6807\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_SIGN_KEY_ERROR);
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo, String keys) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + JWT_DEFAULT_EXPIRATION_TIME;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)Keys.hmacShaKeyFor((byte[])keys.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (InvalidKeyException e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0cJWT\u79d8\u94a5\u590d\u6742\u5ea6\u672a\u8fbe\u6807\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_SIGN_KEY_ERROR);
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpireInMinutes(Object userInfo, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusMinutes(expire).toDate()).signWith((Key)Keys.hmacShaKeyFor((byte[])JWT_DEFAULT_SIGN_KEY.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpireInSeconds(Object userInfo, int expire) {
        try {
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(DateTime.now().plusSeconds(expire).toDate()).signWith((Key)Keys.hmacShaKeyFor((byte[])JWT_DEFAULT_SIGN_KEY.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo, Long expire) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + expire;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)Keys.hmacShaKeyFor((byte[])JWT_DEFAULT_SIGN_KEY.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static String generateTokenExpire(Object userInfo) {
        try {
            long nowMillis = System.currentTimeMillis();
            long expMillis = nowMillis + JWT_DEFAULT_EXPIRATION_TIME;
            return Jwts.builder().claim(JWT_PAYLOAD_USER_KEY, (Object)JacksonUtils.toString(userInfo)).setId(JwtUtils.createJTI()).setSubject(JWT_PAYLOAD_SUBJECT_VALUE).setIssuedAt(new Date()).setExpiration(new Date(expMillis)).signWith((Key)Keys.hmacShaKeyFor((byte[])JWT_DEFAULT_SIGN_KEY.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256).compact();
        }
        catch (Exception e) {
            log.error("Token\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_GENERATE_TOKEN_ERROR);
        }
    }

    public static Boolean validateToken(String token, PublicKey publicKey) {
        Date expiredDate = JwtUtils.getExpiredDateFromToken(token, publicKey);
        return expiredDate.before(new Date());
    }

    public static Boolean validateToken(String token, String keys) {
        Date expiredDate = JwtUtils.getExpiredDateFromToken(token, keys);
        return expiredDate.before(new Date());
    }

    public static Boolean validateToken(String token) {
        Date expiredDate = JwtUtils.getExpiredDateFromToken(token);
        return expiredDate.before(new Date());
    }

    public static Date getExpiredDateFromToken(String token, PublicKey publicKey) {
        Claims claimsFromToken = JwtUtils.getClaimsFromToken(token, publicKey);
        return claimsFromToken.getExpiration();
    }

    public static Date getExpiredDateFromToken(String token, String keys) {
        Claims claimsFromToken = JwtUtils.getClaimsFromToken(token, keys);
        return claimsFromToken.getExpiration();
    }

    public static Date getExpiredDateFromToken(String token) {
        Claims claimsFromToken = JwtUtils.getClaimsFromToken(token);
        return claimsFromToken.getExpiration();
    }

    public static <T> T getInfoFromToken(String token, PublicKey publicKey, Class<T> userType) {
        Claims body = JwtUtils.getClaimsFromToken(token, publicKey);
        return JacksonUtils.toBean(body.get((Object)JWT_PAYLOAD_USER_KEY).toString(), userType);
    }

    public static <T> T getInfoFromToken(String token, String keys, Class<T> userType) {
        Claims body = JwtUtils.getClaimsFromToken(token, keys);
        return JacksonUtils.toBean(body.get((Object)JWT_PAYLOAD_USER_KEY).toString(), userType);
    }

    public static <T> T getInfoFromToken(String token, Class<T> userType) {
        Claims body = JwtUtils.getClaimsFromToken(token);
        return JacksonUtils.toBean(body.get((Object)JWT_PAYLOAD_USER_KEY).toString(), userType);
    }

    private static String createJTI() {
        return new String(Base64.getEncoder().encode(UUID.randomUUID().toString().getBytes()));
    }

    private static Jws<Claims> parserToken(String token, PublicKey publicKey) {
        try {
            JwtParser jwtParser = Jwts.parserBuilder().setSigningKey((Key)publicKey).build();
            return jwtParser.parseClaimsJws(token);
        }
        catch (ExpiredJwtException e) {
            log.info("Token\u5df2\u5931\u6548\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_EXPIRED);
        }
        catch (UnsupportedJwtException e) {
            log.info("\u975e\u672c\u7ad9\u7b7e\u53d1\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_UNSUPPORTED);
        }
        catch (MalformedJwtException e) {
            log.info("\u683c\u5f0f\u9519\u8bef\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_MALFORMED);
        }
        catch (SignatureException e) {
            log.info("\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_SIGN);
        }
        catch (IllegalArgumentException e) {
            log.info("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_ILLEGAL_ARGUMENT);
        }
        catch (Exception e) {
            log.info("Token\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR);
        }
    }

    private static Jws<Claims> parserToken(String token, String keys) {
        try {
            JwtParser jwtParser = Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])keys.getBytes(StandardCharsets.UTF_8))).build();
            return jwtParser.parseClaimsJws(token);
        }
        catch (ExpiredJwtException e) {
            log.info("Token\u5df2\u5931\u6548\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_EXPIRED);
        }
        catch (UnsupportedJwtException e) {
            log.info("\u975e\u672c\u7ad9\u7b7e\u53d1\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_UNSUPPORTED);
        }
        catch (MalformedJwtException e) {
            log.info("\u683c\u5f0f\u9519\u8bef\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_MALFORMED);
        }
        catch (SignatureException e) {
            log.info("\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_SIGN);
        }
        catch (IllegalArgumentException e) {
            log.info("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_ILLEGAL_ARGUMENT);
        }
        catch (Exception e) {
            log.info("Token\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR);
        }
    }

    private static Jws<Claims> parserToken(String token) {
        try {
            JwtParser jwtParser = Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])JWT_DEFAULT_SIGN_KEY.getBytes(StandardCharsets.UTF_8))).build();
            return jwtParser.parseClaimsJws(token);
        }
        catch (ExpiredJwtException e) {
            log.info("Token\u5df2\u5931\u6548\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_EXPIRED);
        }
        catch (UnsupportedJwtException e) {
            log.info("\u975e\u672c\u7ad9\u7b7e\u53d1\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_UNSUPPORTED);
        }
        catch (MalformedJwtException e) {
            log.info("\u683c\u5f0f\u9519\u8bef\u7684Token\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_MALFORMED);
        }
        catch (SignatureException e) {
            log.info("\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_SIGN);
        }
        catch (IllegalArgumentException e) {
            log.info("\u975e\u6cd5\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR_ILLEGAL_ARGUMENT);
        }
        catch (Exception e) {
            log.info("Token\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new SnowException(CommonExceptionEnum.JWT_PARSER_TOKEN_ERROR);
        }
    }

    private static Claims getClaimsFromToken(String token, PublicKey publicKey) {
        Jws<Claims> claimsJws = JwtUtils.parserToken(token, publicKey);
        return (Claims)claimsJws.getBody();
    }

    private static Claims getClaimsFromToken(String token, String keys) {
        Jws<Claims> claimsJws = JwtUtils.parserToken(token, keys);
        return (Claims)claimsJws.getBody();
    }

    private static Claims getClaimsFromToken(String token) {
        Jws<Claims> claimsJws = JwtUtils.parserToken(token);
        return (Claims)claimsJws.getBody();
    }

    public static void main(String[] args) throws Exception {
        String publicKeyName = "D:\\worksoft\\javaee117\\ssh\\id_rsa.pub";
        String privateKeyName = "D:\\worksoft\\javaee117\\ssh\\id_rsa";
        PublicKey publicKey = RsaUtils.getPublicKey(publicKeyName);
        PrivateKey privateKey = RsaUtils.getPrivateKey(privateKeyName);
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("id", 1L);
        userInfo.put("username", JWT_PAYLOAD_SUBJECT_VALUE);
        userInfo.put("role", "guest");
        String token = "eyJhbGciOiJSUzI1NiJ9.eyJ1c2VyIjoie1wiaWRcIjoxLsdfasasfd5hbWVcIjpcImxleW91XCIsXCJyb2xlXCI6XCJndWVzdFwifSIsImp0aSI6Ik1ESTNNakppWW1NdE16QTFNaTAwTTJJekxXRTFNRFl0Tm1Oa1pqaGlObUkzTVRWbCIsImV4cCI6MTU4MTA2NDM5NX0.h4PZdpjQbXIkbktMJ-SGE77vNFnMcXTMnESL7l6HNGYIvfY29C_k3DmwZSbqRO-cotYEvTgtDMcZur4kW3mVqR-veGWav9lCdT4CWG0Q-0xUPT9ADEVaKfXgzHm4Nrfp9KropIHN_RzDpzlUYFlrhkrn9fpxrTQTy4NN5JdBNLvf4cW10_RHZbng4xOx7CvipTPhAqibQaK4IeqTE5kafXgO4e114VPF4u5Mnpnrav8unYthgsjpPUXb_Hzw8GKAlXI8epfwAUOxsMeyhGfHslnqXTrz8YSOJqyDF4vH_s6cPUuo1B2laMzPP13CqQhx7OY5PpvZZXRi5Vq8dPfpWg";
        Map payload = JwtUtils.getInfoFromToken(token, publicKey, Map.class);
        System.out.println(payload);
    }
}

