package cn.lonelysnow.common.utils.threads;

/**
 * @author LonelySnow
 * @classname ThreadLocal
 * @description ThreadLocal线程工具类
 * @date 2022/10/15 11:00
 */
public class ThreadLocalUtils {

    private static final java.lang.ThreadLocal<ThreadLocalDate> TL = new java.lang.ThreadLocal<>();

    public static <T> void setInfo(ThreadLocalDate date) {
        TL.set(date);
    }

    public static ThreadLocalDate getInfo() {
        return TL.get();
    }

    public static Integer getUserId() {
        return TL.get().getUserId();
    }

    public static String getUserName() {
        return TL.get().getUsername();
    }

    public static void remove() {
        TL.remove();
    }

}
