package cn.lonelysnow.common.utils.random;

import java.util.Random;

/**
 * @author LonelySnow
 * @classname RandomCode
 * @description 随机码生成
 * @created LonelySnow
 * @date 2021/8/7 9:27 上午
 */
public class RandomCode {

    /**
     * 纯数字随机值
     * @author LonelySnow
     * @param num
     * @result java.lang.String
     * @date 2021/8/7 9:30 上午
     */
    public static String numberCode(int num) {
        int rs = (int) ((Math.random() * 9 + 1) * Math.pow(10, num - 1));
        return String.valueOf(rs);
    }

    /**
     * 生成纯字母值
     * @author LonelySnow
     * @param num
     * @result java.lang.String
     * @date 2021/8/7 9:33 上午
     */
    public static String letterCode(int num) {
        String source = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < num; i++) {
            rs.append(source.charAt(r.nextInt(source.length())));
        }
        return rs.toString();
    }

    /**
     * 生成字母数字混合值
     * @author LonelySnow
     * @param num
     * @result java.lang.String
     * @date 2021/8/7 9:35 上午
     */
    public static String letterNumCode(int num) {
        String source = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789";
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < num; i++) {
            rs.append(source.charAt(r.nextInt(source.length())));
        }
        return rs.toString();
    }

    /**
     * 生成混合值，包括符号
     * @author LonelySnow
     * @param num
     * @result java.lang.String
     * @date 2021/8/7 9:37 上午
     */
    public static String builderCode(int num) {
        String source = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz0123456789.,;:'\"/?\\`~|{}[]_-+=!@#$%^&*()";
        Random r = new Random();
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < num; i++) {
            rs.append(source.charAt(r.nextInt(source.length())));
        }
        return rs.toString();
    }



}
