package cn.lonelysnow.common.utils.datatype;

import java.util.Random;

/**
 * @author LonelySnow
 * @classname RandomArray
 * @description 数组内容顺序随机处理
 * @created LonelySnow
 * @date 2022/4/7 12:39
 */
public class RandomArray {

    private static Random rand = new Random();

    public static <T> void swap(T[] a, int i, int j) {
        T temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    /**
     * 随即数组内容
     * @author LonelySnow
     * @param arr
     * @result void
     * @date 2022/4/15 08:27
     */
    public static <T> void shuffle(T[] arr) {
        int length = arr.length;
        for (int i = length; i > 0; i--) {
            int randInt = rand.nextInt(i);
            swap(arr, randInt, i - 1);
        }
    }

}