package cn.lonelysnow.common.utils.bean;

import cn.lonelysnow.common.exception.CommonExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author LonelySnow
 * @classname BeanHelper
 * @description 对象处理工具类
 * @created LonelySnow
 * @date 2021/8/6 11:03 下午
 *  转换时候，两个类中的变量名，以及变量类型相同才会复制成功
 */
@Slf4j
public class BeanHelper {

    /**
     * 实体类转实体类
     * @author LonelySnow
     * @param source
     * @param target
     * @result T
     * @date 2021/8/6 11:07 下午
     */
    public static <T> T copyProperties(Object source, Class<T> target) {
        try {
            T t = target.newInstance();
            BeanUtils.copyProperties(source, t);
            return t;
        } catch (Exception e) {
            log.error("数据转换出错，目标对象{}构造函数异常", target.getName(), e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }

    public static <T> List<T> copyWithCollection(List<?> sourceList, final Class<T> target) {
        try {
            return sourceList.stream().map(
                    s -> copyProperties(s, target)
            ).collect(Collectors.toList());
        } catch (Exception e) {
            log.error("数据转换出错，目标对象{}构造函数异常", target.getName(), e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }

    public static <T> Set<T> copyWithCollection(Set<?> sourceList, Class<T> target) {
        try {
            return sourceList.stream().map(
                    s -> copyProperties(s, target)
            ).collect(Collectors.toSet());
        } catch (Exception e) {
            log.error("数据转换出错，目标对象{}构造函数异常", target.getName(), e);
            throw new SnowException(CommonExceptionEnum.DATA_TRANSFER_ERROR);
        }
    }

}
