package cn.lonelysnow.common.result;

import cn.lonelysnow.common.exception.BaseExceptionEnum;
import cn.lonelysnow.common.exception.SnowException;
import lombok.Data;
import org.joda.time.DateTime;

/**
 * @author LonelySnow
 * @classname Result
 * @description 定义成功返回类型
 * @created LonelySnow
 * @date 2021/8/6 10:58 下午
 */
@Data
public class Result<T> {

    /**
     * 返回码
     */
    private Integer code;

    /**
     * 返回信息
     */
    private String message;

    /**
     * 内容
     */
    private T data;

    /**
     * 时间
     */
    private String timestamp;

    public Result(T data) {
        this.code = 0;
        this.message = "success";
        this.data = data;
        this.timestamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 返回成数据
     * @author LonelySnow
     * @param data
     * @return cn.lonelysnow.common.result.Result<T>
     * @date 2022/9/14 16:43
     */
    public static <T> Result<T> success(T data) {
        return new Result(data);
    }

    /**
     * 返回失败数据
     * @author LonelySnow
     * @param em
     * @return void
     * @date 2022/9/14 16:43
     */
    public static void error(BaseExceptionEnum em) {
        throw new SnowException(em);
    }

    /**
     * 返回失败数据
     * @author LonelySnow
     * @param message
     * @return void
     * @date 2022/9/14 16:43
     */
    public static void error(String message) {
        error(444, 100000, message);
    }

    /**
     * 返回失败数据
     * @author LonelySnow
     * @param httpCode
     * @param errorCode
     * @param message
     * @return void
     * @date 2022/9/14 16:48
     */
    public static void error(Integer httpCode, Integer errorCode, String message) {
        throw new SnowException(httpCode, errorCode, message);
    }

}
