package cn.lonelysnow.common.page;

import lombok.Data;

import java.util.List;

/**
 * @author LonelySnow
 * @classname PageResult
 * @description 自定义分页内容
 * @created LonelySnow
 * @date 2021/8/6 10:50 下午
 */
@Data
public class PageResult<T> {

    /**
     * 当前页码
     */
    private Long page;

    /**
     * 每页展示条数
     */
    private Long rows;

    /**
     * 总页数
     */
    private Long totalPage;

    /**
     * 总条数
     */
    private Long totalSize;

    /**
     * 内容
     */
    private List<T> items;

    public PageResult() {

    }

    public PageResult(Long totalSize, List<T> items) {
        this.totalSize = totalSize;
        this.items = items;
    }

    public PageResult(Long totalSize, Long totalPage, List<T> items) {
        this.totalSize = totalSize;
        this.totalPage = totalPage;
        this.items = items;
    }

    public PageResult(Long rows, Long page, Long totalSize, Long totalPage, List<T> items) {
        this.rows = rows;
        this.page = page;
        this.totalSize = totalSize;
        this.totalPage =  totalPage;
        this.items = items;
    }

}
