package cn.lonelysnow.common.exception;

import lombok.Data;
import org.joda.time.DateTime;

/**
 * @author LonelySnow
 * @classname SnowException
 * @description 自定义异常处理
 * @created LonelySnow
 * @date 2021/8/6 10:22 下午
 */
@Data
public class SnowException extends RuntimeException {

    private Integer httpCode;

    private Integer errCode;

    private String timeStamp;

    public SnowException() {

    }

    public SnowException(Integer httpCode, Integer errCode, String message) {
        super(message);
        this.httpCode = httpCode;
        this.errCode = errCode;
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(BaseExceptionEnum em) {
        super(em.getMessage());
        this.httpCode = em.getHttpCode();
        this.errCode = em.getErrCode();
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(Integer httpCode, Integer errCode, String message, Throwable cause) {
        super(message, cause);
        this.httpCode = httpCode;
        this.errCode = errCode;
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public SnowException(BaseExceptionEnum em, Throwable cause) {
        super(em.getMessage(), cause);
        this.httpCode = em.getHttpCode();
        this.errCode = em.getErrCode();
        this.timeStamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

}
