package cn.lonelysnow.common.exception;

import lombok.Data;
import org.joda.time.DateTime;

/**
 * @author LonelySnow
 * @classname ExceptionResult
 * @description 定义异常返回格式
 * @created LonelySnow
 * @date 2021/8/6 10:33 下午
 */
@Data
public class ExceptionResult {

    private Integer code;

    private String message;

    private String data;

    private String timestamp;

    public ExceptionResult(SnowException e) {
        this.code = e.getErrCode();
        this.message = "error";
        this.data = e.getMessage();
        this.timestamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public ExceptionResult(BaseExceptionEnum e) {
        this.code = e.getErrCode();
        this.message = "error";
        this.data = e.getMessage();
        this.timestamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

    public ExceptionResult(String message) {
        this.code = 999999;
        this.message = "error";
        this.data = message;
        this.timestamp = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
    }

}
