package cn.lonelysnow.common.exception;

/**
 * @author LonelySnow
 * @classname CommonExceptionEnum
 * @description 异常类型枚举
 * @created LonelySnow
 * @date 2021/8/6 10:37 下午
 *
 *  系统自定义报错信息
 *  内容格式：HTTP错误码，自定义错误码，文字描述
 *  HTTP错误码：
 *      4xx：资源以及权限等问题
 *      5xx：服务器问题
 *  自定义错误码：默认六位
 *      1xxxxx：系统通用错误
 *      2xxxxx：请求相关错误
 *      3xxxxx：服务处理错误
 *    注意：
 *      2、3开头的自定义错误码中，第1位表示错误类型、第2-3位表示所属服务、第4-6位表示具体错误信息
 *          后续位数不够，再做添加
 */
public enum CommonExceptionEnum implements BaseExceptionEnum {

    // 404
    RESOURCE_NOT_FOUND(404, 100000, "资源未找到"),
    // 数据转换异常
    DATA_TRANSFER_ERROR(500, 100001, "数据转换异常"),
    // Json解析出错
    JSON_PARSING_ERROR(500, 100002, "Json解析出错"),
    // Token生成失败
    JWT_GENERATE_TOKEN_ERROR(500, 100003, "Token生成失败"),
    // JWT自定义秘钥复杂度未达标
    JWT_GENERATE_TOKEN_SIGN_KEY_ERROR(500, 100004, "JWT秘钥复杂度未达标，Token生成失败"),
    // JWT token解析失败
    JWT_PARSER_TOKEN_ERROR(500, 100005, "JWT解析token失败"),
    // Token已失效
    JWT_PARSER_TOKEN_ERROR_EXPIRED(401, 100006, "Token已失效，请重新登录"),
    // Token非法，非本站签发，无法解析
    JWT_PARSER_TOKEN_ERROR_UNSUPPORTED(401, 100007, "Token非法"),
    // Token格式异常
    JWT_PARSER_TOKEN_ERROR_MALFORMED(401, 100008, "Token异常"),
    // Token使用签名异常
    JWT_PARSER_TOKEN_ERROR_SIGN(500, 100009, "Token签名错误！"),
    // Token解析发生非法参数异常
    JWT_PARSER_TOKEN_ERROR_ILLEGAL_ARGUMENT(500, 100010, "Token解析发生非法参数"),
    // RSA算法指定错误
    RSA_NO_SUCH_ALGORITHM(500, 100011, "RSA算法指定错误"),
    // RSA秘钥失效
    RSA_INVALID_KEY_SPEC(500, 100012, "RSA秘钥已失效"),
    // RSA文件读取失败
    RSA_FILE_READ_ERROR(500, 100013, "RSA文件读取失败"),
    ;

    /**
     * http异常状态码
     */
    private Integer httpCode;

    /**
     * 自定义异常状态码
     */
    private Integer errCode;

    /**
     * 异常提示信息
     */
    private String message;

    CommonExceptionEnum(Integer httpCode, Integer errCode, String message) {
        this.httpCode = httpCode;
        this.errCode = errCode;
        this.message = message;
    }

    @Override
    public Integer getHttpCode() {
        return httpCode;
    }

    @Override
    public Integer getErrCode() {
        return errCode;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
