package cn.lonelysnow.common.exception;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.NoHandlerFoundException;

/**
 * @author LonelySnow
 * @classname BaseExceptionAdvice
 * @description 通用异常处理类
 * @created LonelySnow
 * @date 2021/8/6 10:17 下午
 */
@ControllerAdvice
public class BaseExceptionAdvice {

    /**
     * 运行时异常处理方案
     * @param e
     * @author LonelySnow
     * @result org.springframework.http.ResponseEntity<java.lang.String>
     * @date 2021/8/6 10:21 下午
     */
    @ExceptionHandler(RuntimeException.class)
    public ResponseEntity<ExceptionResult> handleRuntimeException(RuntimeException e) {
        return ResponseEntity.status(500).body(new ExceptionResult(e.getMessage()));
    }

    /**
     * 自定义异常处理方案
     * @author LonelySnow
     * @param e
     * @result org.springframework.http.ResponseEntity<cn.snow.common.exception.ExceptionResult>
     * @date 2021/8/6 10:36 下午
     */
    @ExceptionHandler(SnowException.class)
    public ResponseEntity<ExceptionResult> handleException(SnowException e) {
        return ResponseEntity.status(e.getHttpCode()).body(new ExceptionResult(e));
    }

    /**
     * 全局404异常捕获
     * @author LiHongzeng
     * @param e
     * @result org.springframework.http.ResponseEntity<cn.rails.building.common.exception.ExceptionResult>
     * @date 2022/7/13 16:18
     */
    @ExceptionHandler(NoHandlerFoundException.class)
    public ResponseEntity<ExceptionResult> handleNoHandlerFoundException(NoHandlerFoundException e) {
        return ResponseEntity.status(404).body(new ExceptionResult(CommonExceptionEnum.RESOURCE_NOT_FOUND));
    }

}
