/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u001a\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J \u0010\u0018\u001a\u00020\u00042\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J \u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001aH\u0007J\u001c\u0010\u001d\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0007J&\u0010\u001f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcn/lnkdoc/sdk/uia/instance/bjtoon/util/encryption/RSACoder;", "", "()V", "KEY_ALGORITHM", "", "MAX_DECRYPT_BLOCK", "", "MAX_ENCRYPT_BLOCK", "PRIVATE_KEY", "PUBLIC_KEY", "SIGNATURE_ALGORITHM", "decrypt", "", "cipher", "Ljavax/crypto/Cipher;", "privateK", "Ljava/security/Key;", "data", "decryptByPrivateKey", "key", "decryptByPublicKey", "encrypt", "encryptByPrivateKey", "encryptByPublicKey", "getPrivateKey", "keyMap", "", "getPublicKey", "initKey", "sign", "privateKey", "verify", "", "publicKey", "awesome-uia-sdk"})
public final class RSACoder {
    @NotNull
    public static final RSACoder INSTANCE = new RSACoder();
    @NotNull
    private static final String KEY_ALGORITHM = "RSA";
    @NotNull
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    @NotNull
    private static final String PUBLIC_KEY = "RSAPublicKey";
    @NotNull
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    private RSACoder() {
    }

    @JvmStatic
    @NotNull
    public static final String sign(@Nullable byte[] data, @Nullable String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        String string = Base64.encodeBase64String((byte[])signature.sign());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        return string;
    }

    @JvmStatic
    public static final boolean verify(@Nullable byte[] data, @Nullable String publicKey, @Nullable String sign) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    @JvmStatic
    @NotNull
    public static final byte[] decryptByPrivateKey(@NotNull byte[] data, @Nullable String key) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] keyBytes = Base64.decodeBase64((String)key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"generatePrivate(...)");
        Key privateK = privateKey;
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        Intrinsics.checkNotNull((Object)cipher);
        return INSTANCE.decrypt(cipher, privateK, data);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decryptByPublicKey(@NotNull byte[] data, @Nullable String key) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] keyBytes = Base64.decodeBase64((String)key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        Key publicK = publicKey;
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        Intrinsics.checkNotNull((Object)cipher);
        return INSTANCE.decrypt(cipher, publicK, data);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptByPublicKey(@NotNull byte[] data, @Nullable String key) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] keyBytes = Base64.decodeBase64((String)key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        Key publicK = publicKey;
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        Intrinsics.checkNotNull((Object)cipher);
        return INSTANCE.encrypt(cipher, publicK, data);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptByPrivateKey(@NotNull byte[] data, @Nullable String key) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] keyBytes = Base64.decodeBase64((String)key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"generatePrivate(...)");
        Key privateK = privateKey;
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        Intrinsics.checkNotNull((Object)cipher);
        return INSTANCE.encrypt(cipher, privateK, data);
    }

    @JvmStatic
    @NotNull
    public static final String getPrivateKey(@NotNull Map<String, ? extends Object> keyMap) {
        Key key;
        Intrinsics.checkNotNullParameter(keyMap, (String)"keyMap");
        Key key2 = key = (Key)keyMap.get(PRIVATE_KEY);
        Intrinsics.checkNotNull((Object)key2);
        String string = Base64.encodeBase64String((byte[])key2.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getPublicKey(@NotNull Map<String, ? extends Object> keyMap) {
        Key key;
        Intrinsics.checkNotNullParameter(keyMap, (String)"keyMap");
        Key key2 = key = (Key)keyMap.get(PUBLIC_KEY);
        Intrinsics.checkNotNull((Object)key2);
        String string = Base64.encodeBase64String((byte[])key2.getEncoded());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        RSAPublicKey publicKey2 = (RSAPublicKey)publicKey;
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        RSAPrivateKey privateKey2 = (RSAPrivateKey)privateKey;
        Map keyMap = new HashMap(2);
        keyMap.put(PUBLIC_KEY, publicKey2);
        keyMap.put(PRIVATE_KEY, privateKey2);
        return keyMap;
    }

    private final byte[] decrypt(Cipher cipher, Key privateK, byte[] data) {
        cipher.init(2, privateK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache = null;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] byArray;
            byte[] byArray2;
            if (inputLen - offSet > 128) {
                byArray2 = cipher.doFinal(data, offSet, 128);
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            } else {
                byArray2 = cipher.doFinal(data, offSet, inputLen - offSet);
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            }
            cache = byArray;
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        Intrinsics.checkNotNull((Object)decryptedData);
        return decryptedData;
    }

    private final byte[] encrypt(Cipher cipher, Key privateK, byte[] data) {
        cipher.init(1, privateK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache = null;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] byArray;
            byte[] byArray2;
            if (inputLen - offSet > 117) {
                byArray2 = cipher.doFinal(data, offSet, 117);
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            } else {
                byArray2 = cipher.doFinal(data, offSet, inputLen - offSet);
                Intrinsics.checkNotNull((Object)byArray2);
                byArray = byArray2;
            }
            cache = byArray;
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        Intrinsics.checkNotNull((Object)encryptedData);
        return encryptedData;
    }
}

