/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bccastle.client;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.converter.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.interceptor.DefaultUiaClientInterceptor;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.IUiaResponse;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.bccastle.property.BccastleProperty;
import cn.lnkdoc.sdk.uia.instance.bccastle.util.CheckResponseUtil;
import com.alibaba.fastjson2.JSON;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/lnkdoc/sdk/uia/instance/bccastle/client/BccastleUiaClient;", "Lcn/lnkdoc/sdk/uia/common/client/IUiaClient;", "()V", "builder", "Lokhttp3/OkHttpClient$Builder;", "interceptor", "Lokhttp3/Interceptor;", "property", "Lcn/lnkdoc/sdk/uia/instance/bccastle/property/BccastleProperty;", "buildClient", "Lokhttp3/OkHttpClient;", "execute", "Lcn/lnkdoc/sdk/uia/common/response/IUiaResponse;", "RESP", "request", "Lcn/lnkdoc/sdk/uia/common/request/IUiaRequest;", "sendRequest", "", "Companion", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nBccastleUiaClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BccastleUiaClient.kt\ncn/lnkdoc/sdk/uia/instance/bccastle/client/BccastleUiaClient\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n*L\n1#1,149:1\n183#2:150\n*S KotlinDebug\n*F\n+ 1 BccastleUiaClient.kt\ncn/lnkdoc/sdk/uia/instance/bccastle/client/BccastleUiaClient\n*L\n108#1:150\n*E\n"})
public final class BccastleUiaClient
implements IUiaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
    @NotNull
    private final Interceptor interceptor = new DefaultUiaClientInterceptor();
    private BccastleProperty property;
    private static final Logger log = LoggerFactory.getLogger(BccastleUiaClient.class);

    private BccastleUiaClient() {
    }

    @Override
    @NotNull
    public <RESP> IUiaResponse<RESP> execute(@NotNull IUiaRequest request) throws UiaException {
        IUiaResponse iUiaResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            String string = this.sendRequest(request);
            BccastleProperty bccastleProperty = this.property;
            if (bccastleProperty == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"property");
                bccastleProperty = null;
            }
            CheckResponseUtil.INSTANCE.check(string, bccastleProperty.isPrintStack());
            List<IUiaConverter> converts = request.getConvert();
            Assert.required(converts, "not found converter for [" + request.getClass().getSimpleName() + ']');
            IUiaConverter convert = converts.get(0);
            Object resp = convert.convertResponse(string);
            iUiaResponse = UiaResponse.Companion.success(resp);
        }
        catch (Exception e) {
            BccastleProperty bccastleProperty = this.property;
            if (bccastleProperty == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"property");
                bccastleProperty = null;
            }
            if (bccastleProperty.isPrintStack()) {
                log.error("", (Throwable)e);
            }
            iUiaResponse = UiaResponse.Companion.fail(e.getMessage());
        }
        return iUiaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String sendRequest(IUiaRequest request) {
        BccastleProperty bccastleProperty = this.property;
        if (bccastleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"property");
            bccastleProperty = null;
        }
        String url = request.url(bccastleProperty);
        String string = "[%s][%s]";
        Object[] objectArray = new Object[]{request.method(), url};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String logMessage = string2;
        boolean success = false;
        String string3 = null;
        string3 = "";
        IUiaConverter convert = request.getConvert().get(0);
        BccastleProperty bccastleProperty2 = this.property;
        if (bccastleProperty2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"property");
            bccastleProperty2 = null;
        }
        Tuple2 tuple2 = Tuple.of((Object)bccastleProperty2, (Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)tuple2, (String)"of(...)");
        RequestBody body = (RequestBody)convert.convertRequest(tuple2);
        Request httpRequest = new Request.Builder().url(url).method(request.method().getMethod(), (RequestBody)(HttpMethod.POST == request.method() ? body : null)).build();
        BccastleProperty bccastleProperty3 = this.property;
        if (bccastleProperty3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"property");
            bccastleProperty3 = null;
        }
        OkHttpClient client = this.buildClient(bccastleProperty3);
        Object[] objectArray2 = (Closeable)client.newCall(httpRequest).execute();
        Throwable throwable = null;
        Response response2 = (Response)objectArray2;
        boolean bl = false;
        ResponseBody responseBody = response2.body();
        Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + ']');
        ResponseBody responseBody2 = responseBody;
        Intrinsics.checkNotNull((Object)responseBody2);
        String $this$isJSONObject$iv = string3 = responseBody2.string();
        boolean $i$f$isJSONObject = false;
        success = JSON.isValidObject((String)$this$isJSONObject$iv);
        String string4 = string3;
        CloseableKt.closeFinally((Closeable)objectArray2, (Throwable)throwable);
        String string5 = string4;
        Object[] objectArray3 = new Object[]{logMessage, success, string3};
        log.debug("{}[{}][{}]", objectArray3);
        return string5;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)objectArray2, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        throw new UiaException(e);
                    }
                }
                catch (Throwable throwable4) {
                    objectArray2 = new Object[]{logMessage, success, string3};
                    log.debug("{}[{}][{}]", objectArray2);
                    throw throwable4;
                }
            }
        }
    }

    private final OkHttpClient buildClient(BccastleProperty property) {
        if (property.isUseInterceptor()) {
            this.builder.addInterceptor(this.interceptor);
        }
        return this.builder.build();
    }

    public /* synthetic */ BccastleUiaClient(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcn/lnkdoc/sdk/uia/instance/bccastle/client/BccastleUiaClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkMustRequired", "", "property", "Lcn/lnkdoc/sdk/uia/instance/bccastle/property/BccastleProperty;", "getInstance", "Lcn/lnkdoc/sdk/uia/instance/bccastle/client/BccastleUiaClient;", "awesome-uia-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BccastleUiaClient getInstance(@NotNull BccastleProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            BccastleUiaClient client = new BccastleUiaClient(null);
            client.property = property;
            this.checkMustRequired(property);
            return client;
        }

        private final void checkMustRequired(BccastleProperty property) {
            Assert.required(property, "the uiaConfiguration is required");
            Assert.required(property.getDomain(), "the domain configuration is required");
            Assert.required(property.getClientId(), "the clientId configuration is required");
            Assert.required(property.getClientSecret(), "the clientSecret configuration is required");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

