/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.common.util.cert;

import cn.lnkdoc.sdk.uia.common.util.cert.SavingTrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0007J\u001b\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/lnkdoc/sdk/uia/common/util/cert/InstallCert;", "", "()V", "DEFAULT_KEYSTORE_PASSWORD", "", "DEFAULT_KEYS_STORE_NAME", "HEX_DIGITS", "", "KEYS_STORE_NAME", "PROJECT_HOME", "kotlin.jvm.PlatformType", "SECURITY_CERT_HOME", "SEPARATOR", "", "generateTrustStore", "", "domain", "password", "main", "args", "", "([Ljava/lang/String;)V", "toHexString", "bytes", "", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nInstallCert.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallCert.kt\ncn/lnkdoc/sdk/uia/common/util/cert/InstallCert\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,198:1\n107#2:199\n79#2,22:200\n107#2:233\n79#2,22:234\n731#3,9:222\n37#4,2:231\n*S KotlinDebug\n*F\n+ 1 InstallCert.kt\ncn/lnkdoc/sdk/uia/common/util/cert/InstallCert\n*L\n101#1:199\n101#1:200,22\n161#1:233\n161#1:234,22\n105#1:222,9\n105#1:231,2\n*E\n"})
public final class InstallCert {
    @NotNull
    public static final InstallCert INSTANCE = new InstallCert();
    @NotNull
    private static final char[] HEX_DIGITS;
    private static final char SEPARATOR;
    @NotNull
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    @NotNull
    private static final String KEYS_STORE_NAME = "jssecacerts";
    @NotNull
    private static final String DEFAULT_KEYS_STORE_NAME = "cacerts";
    @NotNull
    private static final String SECURITY_CERT_HOME;
    private static final String PROJECT_HOME;

    private InstallCert() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String domain = "yzt.beijing.gov.cn";
        InstallCert.generateTrustStore$default(domain, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @JvmOverloads
    public static final void generateTrustStore(@NotNull String domain, @Nullable String password) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        varPassword = password;
        if (Objects.isNull(domain)) {
            System.err.println("domain must be not null");
            return;
        }
        keyStoreName = "jssecacerts";
        certFilePath = InstallCert.PROJECT_HOME + InstallCert.SEPARATOR + keyStoreName;
        if (Objects.isNull(varPassword)) ** GOTO lbl-1000
        v0 = varPassword;
        Intrinsics.checkNotNull((Object)v0);
        $this$trim$iv = v0;
        $i$f$trim = false;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            $i$a$-trim-InstallCert$generateTrustStore$1 = false;
            v1 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString()).length() == 0) lbl-1000:
        // 2 sources

        {
            v2 = "changeit";
        } else {
            v2 = varPassword;
        }
        varPassword = v2;
        host = null;
        port = 0;
        $i$f$trim = domain;
        startIndex$iv$iv = new Regex(":");
        endIndex$iv$iv = 0;
        $i$f$trim = startIndex$iv$iv.split((CharSequence)$i$f$trim, endIndex$iv$iv);
        $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                $i$a$-dropLastWhile-InstallCert$generateTrustStore$hostAndPort$1 = false;
                if (((CharSequence)it).length() == 0) continue;
                v3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            v3 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = v3;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        hostAndPort = thisCollection$iv.toArray(new String[0]);
        host = hostAndPort[0];
        port = hostAndPort.length == 1 ? 443 : Integer.parseInt(hostAndPort[1]);
        v4 = varPassword.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toCharArray(...)");
        passwordCharArray = v4;
        file = new File(certFilePath);
        if (!file.isFile() && !(file = new File(dir = new File(InstallCert.SECURITY_CERT_HOME), keyStoreName)).isFile()) {
            file = new File(dir, "cacerts");
        }
        System.out.println((Object)("Loading KeyStore " + file + " ..."));
        in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passwordCharArray);
        in.close();
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        v5 = tmf.getTrustManagers()[0];
        Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        defaultTrustManager = (X509TrustManager)v5;
        tm = new SavingTrustManager(defaultTrustManager);
        context = SSLContext.getInstance("TLS");
        var16_27 = new TrustManager[]{tm};
        context.init(null, var16_27, null);
        factory = context.getSocketFactory();
        System.out.println((Object)("Opening connection to " + host + ':' + port + "..."));
        v6 = factory.createSocket(host, port);
        Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        socket = (SSLSocket)v6;
        socket.setSoTimeout(10000);
        try {
            System.out.println((Object)"Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            var18_29 = "No errors, certificate is already trusted";
            System.out.println((Object)var18_29);
        }
        catch (SSLException e) {
            System.err.println("====================================================================================");
            e.printStackTrace(System.out);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        chain = tm.getChain();
        reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println((Object)("Server sent " + chain.length + " certificate(s):"));
        System.out.println();
        sha1 = MessageDigest.getInstance("SHA1");
        md5 = MessageDigest.getInstance("MD5");
        var23_37 = chain.length;
        for (i = 0; i < var23_37; ++i) {
            cert = chain[i];
            System.out.println((Object)("" + ' ' + (i + 1) + " Subject " + cert.getSubjectX500Principal()));
            System.out.println((Object)("  Issuer  " + cert.getSubjectX500Principal()));
            sha1.update(cert.getEncoded());
            v7 = new StringBuilder().append("  sha1    ");
            v8 = sha1.digest();
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"digest(...)");
            System.out.println((Object)v7.append(InstallCert.toHexString(v8)).toString());
            md5.update(cert.getEncoded());
            v9 = new StringBuilder().append("  md5    ");
            v10 = md5.digest();
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"digest(...)");
            System.out.println((Object)v9.append(InstallCert.toHexString(v10)).toString());
            System.out.println();
        }
        System.out.println((Object)"Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        v11 = reader.readLine();
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"readLine(...)");
        $this$trim$iv = v11;
        $i$f$trim = 0;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            $i$a$-trim-InstallCert$generateTrustStore$line$1 = false;
            v12 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        line = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString();
        try {
            $i$f$trim = ((CharSequence)line).length() == 0 != false ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException e) {
            System.err.println("KeyStore not changed");
            return;
        }
        k = $i$f$trim;
        cert = chain[k];
        alias = host + '-' + (k + 1);
        ks.setCertificateEntry(alias, cert);
        path = Paths.get(certFilePath, new String[0]);
        out = Files.newOutputStream(path, new OpenOption[0]);
        ks.store(out, passwordCharArray);
        out.close();
        System.out.println();
        System.out.println(cert);
        System.out.println();
        System.out.println((Object)("Added certificate to keystore " + certFilePath + " using alias '" + alias + '\''));
    }

    public static /* synthetic */ void generateTrustStore$default(String string, String string2, int n, Object object) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        InstallCert.generateTrustStore(string, string2);
    }

    @JvmStatic
    private static final String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (byte b : bytes) {
            int byteValue = b & 0xFF;
            sb.append(HEX_DIGITS[byteValue >> 4]);
            sb.append(HEX_DIGITS[byteValue & 0xF]);
            sb.append(' ');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    public static final void generateTrustStore(@NotNull String domain) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        InstallCert.generateTrustStore$default(domain, null, 2, null);
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        HEX_DIGITS = cArray;
        SEPARATOR = File.separatorChar;
        SECURITY_CERT_HOME = System.getProperty("java.home") + SEPARATOR + "lib" + SEPARATOR + "security";
        PROJECT_HOME = System.getProperty("user.dir");
    }
}

