/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.common.interceptor;

import cn.lnkdoc.sdk.uia.common.interceptor.AbstractUiaClientInterceptor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcn/lnkdoc/sdk/uia/common/interceptor/DefaultUiaClientInterceptor;", "Lcn/lnkdoc/sdk/uia/common/interceptor/AbstractUiaClientInterceptor;", "()V", "interceptRequest", "", "request", "Lokhttp3/Request;", "interceptResponse", "response", "Lokhttp3/Response;", "Companion", "awesome-uia-sdk"})
public final class DefaultUiaClientInterceptor
extends AbstractUiaClientInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(DefaultUiaClientInterceptor.class);

    @Override
    public void interceptRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        log.info("Sending request: [{}][{}]", (Object)request.method(), (Object)request.url());
        if (request.body() != null) {
            Buffer buffer = new Buffer();
            RequestBody requestBody = request.body();
            Intrinsics.checkNotNull((Object)requestBody);
            requestBody.writeTo((BufferedSink)buffer);
            log.info("Request body: {}", (Object)buffer.readUtf8());
        }
    }

    @Override
    public void interceptResponse(@NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (response2.body() != null) {
            ResponseBody responseBody = response2.peekBody(Long.MAX_VALUE);
            log.info("Received response for [{}] with status code [{}]", (Object)response2.request().url(), (Object)response2.code());
            log.info("Response body: {}", (Object)responseBody.string());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcn/lnkdoc/sdk/uia/common/interceptor/DefaultUiaClientInterceptor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "awesome-uia-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

