/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.gitlab.converter;

import cn.lnkdoc.sdk.uia.common.converter.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.instance.gitlab.converter.AccessTokenConverter;
import cn.lnkdoc.sdk.uia.instance.gitlab.domain.RefreshToken;
import cn.lnkdoc.sdk.uia.instance.gitlab.property.GitlabProperty;
import cn.lnkdoc.sdk.uia.instance.gitlab.request.RefreshTokenRequest;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.TypeReference;
import io.vavr.Tuple2;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.FormBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ!\u0010\t\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcn/lnkdoc/sdk/uia/instance/gitlab/converter/RefreshTokenConverter;", "Lcn/lnkdoc/sdk/uia/instance/gitlab/converter/AccessTokenConverter;", "Lcn/lnkdoc/sdk/uia/common/converter/IUiaConverter;", "()V", "convertRequest", "T", "R", "body", "(Ljava/lang/Object;)Ljava/lang/Object;", "convertResponse", "name", "", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nRefreshTokenConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshTokenConverter.kt\ncn/lnkdoc/sdk/uia/instance/gitlab/converter/RefreshTokenConverter\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n+ 3 TypeReference.kt\ncom/alibaba/fastjson2/TypeReferenceKt\n*L\n1#1,69:1\n46#2:70\n45#2,3:72\n11#3:71\n*S KotlinDebug\n*F\n+ 1 RefreshTokenConverter.kt\ncn/lnkdoc/sdk/uia/instance/gitlab/converter/RefreshTokenConverter\n*L\n30#1:70\n30#1:72,3\n30#1:71\n*E\n"})
public final class RefreshTokenConverter
extends AccessTokenConverter
implements IUiaConverter {
    @Override
    public <T, R> T convertResponse(R body) {
        String string;
        Intrinsics.checkNotNull(body, (String)"null cannot be cast to non-null type io.vavr.Tuple2<kotlin.String, cn.lnkdoc.sdk.uia.instance.gitlab.property.GitlabProperty>");
        Tuple2 tuple = (Tuple2)body;
        String $this$into$iv = string = (String)tuple._1;
        boolean $i$f$into = false;
        boolean $i$f$reference = false;
        RefreshToken data = (RefreshToken)JSON.parseObject((String)$this$into$iv, (Type)((TypeReference)new TypeReference<RefreshToken>(){}).getType());
        if (!data.getSuccess()) {
            throw new UiaException(data.getMessage());
        }
        return (T)data;
    }

    @Override
    public <T, R> T convertRequest(R body) {
        Intrinsics.checkNotNull(body, (String)"null cannot be cast to non-null type io.vavr.Tuple2<cn.lnkdoc.sdk.uia.instance.gitlab.request.RefreshTokenRequest, cn.lnkdoc.sdk.uia.instance.gitlab.property.GitlabProperty>");
        Tuple2 tuple = (Tuple2)body;
        GitlabProperty property = (GitlabProperty)tuple._2;
        RefreshTokenRequest accessTokenRequest = (RefreshTokenRequest)tuple._1;
        FormBody.Builder builder = new FormBody.Builder(null, 1, null);
        FormBody.Builder builder2 = builder.addEncoded("client_id", property.getClientId()).addEncoded("client_secret", property.getClientSecret()).addEncoded("grant_type", "refresh_token").addEncoded("refresh_token", (String)accessTokenRequest.body());
        String string = URLEncoder.encode(property.getRedirectUri(), StandardCharsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        builder2.addEncoded("redirect_uri", string);
        return (T)builder.build();
    }

    @Override
    @NotNull
    public String name() {
        String string = RefreshTokenRequest.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

