/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.alipay.client;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.converter.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.IUiaResponse;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.alipay.SignMode;
import cn.lnkdoc.sdk.uia.instance.alipay.property.AlipayProperty;
import cn.lnkdoc.sdk.uia.instance.alipay.util.CheckResponseUtil;
import com.alibaba.fastjson2.JSON;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayConfig;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/lnkdoc/sdk/uia/instance/alipay/client/AlipayUiaClient;", "Lcn/lnkdoc/sdk/uia/common/client/IUiaClient;", "()V", "client", "Lcom/alipay/api/AlipayClient;", "property", "Lcn/lnkdoc/sdk/uia/instance/alipay/property/AlipayProperty;", "execute", "Lcn/lnkdoc/sdk/uia/common/response/IUiaResponse;", "RESP", "request", "Lcn/lnkdoc/sdk/uia/common/request/IUiaRequest;", "initClient", "", "sendRequest", "Lcom/alipay/api/AlipayResponse;", "Companion", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nAlipayUiaClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlipayUiaClient.kt\ncn/lnkdoc/sdk/uia/instance/alipay/client/AlipayUiaClient\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n*L\n1#1,157:1\n588#2:158\n*S KotlinDebug\n*F\n+ 1 AlipayUiaClient.kt\ncn/lnkdoc/sdk/uia/instance/alipay/client/AlipayUiaClient\n*L\n94#1:158\n*E\n"})
public final class AlipayUiaClient
implements IUiaClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AlipayClient client = (AlipayClient)new DefaultAlipayClient(new CertAlipayRequest());
    @Nullable
    private AlipayProperty property;
    private static final Logger log = LoggerFactory.getLogger(AlipayUiaClient.class);

    private AlipayUiaClient() {
    }

    @Override
    @NotNull
    public <RESP> IUiaResponse<RESP> execute(@NotNull IUiaRequest request) throws UiaException {
        IUiaResponse iUiaResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            AlipayResponse response2 = this.sendRequest(request);
            AlipayProperty alipayProperty = this.property;
            CheckResponseUtil.INSTANCE.check(response2, alipayProperty != null ? Boolean.valueOf(alipayProperty.isPrintStack()) : null);
            List<IUiaConverter> converts = request.getConvert();
            Assert.required(converts, "not found converter for [" + request.getClass().getSimpleName() + ']');
            IUiaConverter convert = converts.get(0);
            Object resp = convert.convertResponse(response2);
            iUiaResponse = UiaResponse.Companion.success(resp);
        }
        catch (Exception e) {
            AlipayProperty alipayProperty = this.property;
            Intrinsics.checkNotNull((Object)alipayProperty);
            if (alipayProperty.isPrintStack()) {
                log.error("", (Throwable)e);
            }
            iUiaResponse = UiaResponse.Companion.fail(e.getMessage());
        }
        return iUiaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AlipayResponse sendRequest(IUiaRequest request) {
        AlipayResponse alipayResponse;
        AlipayUiaClient.Companion.checkMustRequired(this.property);
        this.initClient();
        AlipayProperty alipayProperty = this.property;
        Intrinsics.checkNotNull((Object)alipayProperty);
        String url = request.url(alipayProperty);
        HttpMethod method = request.method();
        String string = "[%s][%s]";
        Object[] objectArray = new Object[]{method, url};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String logMessage = string2;
        boolean success = true;
        String string3 = "";
        IUiaConverter convert = request.getConvert().get(0);
        Tuple3 tuple3 = Tuple.of((Object)this.property, (Object)this.client, (Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)tuple3, (String)"of(...)");
        AlipayRequest alipayRequest = (AlipayRequest)convert.convertRequest(tuple3);
        try {
            AlipayResponse response2;
            alipayResponse = this.client.execute(alipayRequest, (String)request.body());
            if (alipayResponse == null) {
                throw new UiaException("The alipay response is null");
            }
            AlipayResponse $this$toJSONString$iv = response2 = alipayResponse;
            boolean $i$f$toJSONString = false;
            String string4 = JSON.toJSONString((Object)$this$toJSONString$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJSONString(...)");
            string3 = string4;
            alipayResponse = response2;
        }
        catch (Exception e) {
            try {
                success = false;
                throw new UiaException(e);
            }
            catch (Throwable throwable) {
                Object[] objectArray2 = new Object[]{logMessage, success, string3};
                log.debug("{}[{}][{}]", objectArray2);
                throw throwable;
            }
        }
        Object[] objectArray3 = new Object[]{logMessage, success, string3};
        log.debug("{}[{}][{}]", objectArray3);
        return alipayResponse;
    }

    private final void initClient() {
        AlipayProperty alipayProperty = this.property;
        if (Intrinsics.areEqual((Object)(alipayProperty != null ? alipayProperty.getSignMode() : null), (Object)SignMode.PUBLIC_KEY.getSignMode())) {
            AlipayConfig alipayConfig = new AlipayConfig();
            AlipayProperty alipayProperty2 = this.property;
            alipayConfig.setServerUrl(alipayProperty2 != null ? alipayProperty2.getAlipayGatewayUrl() : null);
            AlipayProperty alipayProperty3 = this.property;
            alipayConfig.setAppId(alipayProperty3 != null ? alipayProperty3.getAppId() : null);
            AlipayProperty alipayProperty4 = this.property;
            alipayConfig.setPrivateKey(alipayProperty4 != null ? alipayProperty4.getAppPrivateKey() : null);
            AlipayProperty alipayProperty5 = this.property;
            alipayConfig.setFormat(alipayProperty5 != null ? alipayProperty5.getFormat() : null);
            AlipayProperty alipayProperty6 = this.property;
            alipayConfig.setCharset(alipayProperty6 != null ? alipayProperty6.getCharset() : null);
            AlipayProperty alipayProperty7 = this.property;
            alipayConfig.setAlipayPublicKey(alipayProperty7 != null ? alipayProperty7.getAlipayPublicKey() : null);
            AlipayProperty alipayProperty8 = this.property;
            alipayConfig.setSignType(alipayProperty8 != null ? alipayProperty8.getSignType() : null);
            this.client = (AlipayClient)new DefaultAlipayClient(alipayConfig);
        } else {
            CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
            AlipayProperty alipayProperty9 = this.property;
            certAlipayRequest.setServerUrl(alipayProperty9 != null ? alipayProperty9.getAlipayGatewayUrl() : null);
            AlipayProperty alipayProperty10 = this.property;
            certAlipayRequest.setAppId(alipayProperty10 != null ? alipayProperty10.getAppId() : null);
            AlipayProperty alipayProperty11 = this.property;
            certAlipayRequest.setPrivateKey(alipayProperty11 != null ? alipayProperty11.getAppPrivateKey() : null);
            AlipayProperty alipayProperty12 = this.property;
            certAlipayRequest.setFormat(alipayProperty12 != null ? alipayProperty12.getFormat() : null);
            AlipayProperty alipayProperty13 = this.property;
            certAlipayRequest.setCharset(alipayProperty13 != null ? alipayProperty13.getCharset() : null);
            AlipayProperty alipayProperty14 = this.property;
            certAlipayRequest.setSignType(alipayProperty14 != null ? alipayProperty14.getSignType() : null);
            AlipayProperty alipayProperty15 = this.property;
            certAlipayRequest.setCertPath(alipayProperty15 != null ? alipayProperty15.getAppCertPath() : null);
            AlipayProperty alipayProperty16 = this.property;
            certAlipayRequest.setAlipayPublicCertPath(alipayProperty16 != null ? alipayProperty16.getAlipayCertPath() : null);
            AlipayProperty alipayProperty17 = this.property;
            certAlipayRequest.setRootCertPath(alipayProperty17 != null ? alipayProperty17.getAlipayRootCertPath() : null);
            this.client = (AlipayClient)new DefaultAlipayClient(certAlipayRequest);
        }
    }

    public /* synthetic */ AlipayUiaClient(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcn/lnkdoc/sdk/uia/instance/alipay/client/AlipayUiaClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "checkMustRequired", "", "property", "Lcn/lnkdoc/sdk/uia/instance/alipay/property/AlipayProperty;", "getInstance", "Lcn/lnkdoc/sdk/uia/instance/alipay/client/AlipayUiaClient;", "awesome-uia-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AlipayUiaClient getInstance(@NotNull AlipayProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            AlipayUiaClient client = new AlipayUiaClient(null);
            client.property = property;
            this.checkMustRequired(property);
            return client;
        }

        private final void checkMustRequired(AlipayProperty property) {
            Assert.required(property, "the configuration is required");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

