/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.weibo;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.weibo.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.weibo.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.weibo.property.WeiboProperty;
import cn.lnkdoc.sdk.uia.instance.weibo.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.weibo.request.UserInfoRequest;
import com.alibaba.fastjson2.JSON;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcn/lnkdoc/sdk/uia/example/weibo/Example;", "", "()V", "logger", "Lorg/slf4j/Logger;", "authenticate", "Lcn/lnkdoc/sdk/uia/instance/weibo/domain/AccessToken;", "code", "", "buildOauthUrl", "getUserInfo", "Lcn/lnkdoc/sdk/uia/instance/weibo/domain/UserInfo;", "accessToken", "loadProperty", "Lcn/lnkdoc/sdk/uia/instance/weibo/property/WeiboProperty;", "main", "", "args", "", "([Ljava/lang/String;)V", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nExample.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/weibo/Example\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n*L\n1#1,107:1\n588#2:108\n588#2:109\n*S KotlinDebug\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/weibo/Example\n*L\n32#1:108\n37#1:109\n*E\n"})
public final class Example {
    @NotNull
    public static final Example INSTANCE = new Example();
    @NotNull
    private static final Logger logger;

    private Example() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        UserInfo userInfo;
        AccessToken accessToken2;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        System.out.println((Object)INSTANCE.buildOauthUrl());
        String code = "";
        AccessToken $this$toJSONString$iv = accessToken2 = INSTANCE.authenticate(code);
        boolean $i$f$toJSONString = false;
        String accessTokenJSONString = JSON.toJSONString((Object)$this$toJSONString$iv);
        System.out.println((Object)accessTokenJSONString);
        UserInfo $this$toJSONString$iv2 = userInfo = INSTANCE.getUserInfo(accessToken2);
        boolean $i$f$toJSONString2 = false;
        String userInfoJSONString = JSON.toJSONString((Object)$this$toJSONString$iv2);
        System.out.println((Object)userInfoJSONString);
    }

    private final WeiboProperty loadProperty() {
        WeiboProperty property = new WeiboProperty();
        property.setClientId("");
        property.setClientSecret("");
        property.setRedirectUri("");
        property.setPrintStack(true);
        return property;
    }

    private final AccessToken authenticate(String code) {
        WeiboProperty loadProperty = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(loadProperty);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private final UserInfo getUserInfo(AccessToken accessToken2) {
        WeiboProperty loadProperty = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(loadProperty);
        UserInfoRequest request = new UserInfoRequest();
        UserInfoRequest.Body body = new UserInfoRequest.Body();
        AccessToken accessToken3 = accessToken2;
        body.setAccessToken(accessToken3 != null ? accessToken3.getAccessToken() : null);
        AccessToken accessToken4 = accessToken2;
        body.setUid(accessToken4 != null ? accessToken4.getUid() : null);
        request.setBody(body);
        UiaResponse executeResponse = instance.getUserInfo(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private final String buildOauthUrl() {
        WeiboProperty property = this.loadProperty();
        return "https://api.weibo.com/oauth2/authorize?client_id=" + property.getClientId() + "&response_type=code&state=state&redirect_uri=" + URLEncoder.encode(property.getRedirectUri(), StandardCharsets.UTF_8.name());
    }

    static {
        Logger logger = LoggerFactory.getLogger(cn.lnkdoc.sdk.uia.example.alipay.Example.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Example.logger = logger;
    }
}

