/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.common.util;

import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lcn/lnkdoc/sdk/uia/common/util/EncryptUtils;", "", "()V", "mD5EncryptAsHex", "", "plainText", "saltValue", "awesome-uia-sdk"})
public final class EncryptUtils {
    @NotNull
    public static final EncryptUtils INSTANCE = new EncryptUtils();

    private EncryptUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String mD5EncryptAsHex(@NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        return EncryptUtils.mD5EncryptAsHex(plainText, null);
    }

    @JvmStatic
    @NotNull
    public static final String mD5EncryptAsHex(@NotNull String plainText, @Nullable String saltValue) {
        String string;
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        try {
            byte[] byArray;
            MessageDigest alg = MessageDigest.getInstance("MD5");
            CharSequence[] charSequenceArray = new CharSequence[]{saltValue, plainText};
            String message = String.join((CharSequence)"_", charSequenceArray);
            if (StringUtils.isBlank((CharSequence)saltValue)) {
                String string2 = plainText;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray2 = string2.getBytes(charset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            } else {
                Intrinsics.checkNotNull((Object)message);
                String string3 = message;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                byte[] byArray3 = string3.getBytes(charset2);
                byArray = byArray3;
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
            }
            byte[] encryptBytes = alg.digest(byArray);
            string = Hex.encodeHexString((byte[])encryptBytes);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }
}

