/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption;

import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.AES256Coder;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.DESCoder;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.HexUtil;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.MD5Coder;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.RSACoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/lnkdoc/sdk/uia/instance/bjtoon/util/encryption/CryptoClient;", "", "()V", "CHARSET", "", "decryptWithAES", "info", "aesKey", "decryptWithDES", "encryptData", "key", "decryptWithRSA", "encryptWithAES", "encryptWithDES", "data", "isUrlSafe", "", "encryptWithMD5", "encryptWithRSA", "awesome-uia-sdk"})
public final class CryptoClient {
    @NotNull
    public static final CryptoClient INSTANCE = new CryptoClient();
    @NotNull
    public static final String CHARSET = "UTF-8";

    private CryptoClient() {
    }

    @JvmStatic
    @NotNull
    public static final String encryptWithAES(@NotNull String info, @NotNull String aesKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)aesKey, (String)"aesKey");
        try {
            byte[] key = HexUtil.hexStr2ByteArray(aesKey);
            String string2 = info;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            byte[] encrypt = AES256Coder.encrypt(bytes, key);
            string = HexUtil.byteArray2HexStr(encrypt);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String decryptWithAES(@NotNull String info, @NotNull String aesKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)aesKey, (String)"aesKey");
        try {
            byte[] key = HexUtil.hexStr2ByteArray(aesKey);
            byte[] bytes = HexUtil.hexStr2ByteArray(info);
            byte[] decrypt = AES256Coder.decrypt(bytes, key);
            string = new String(decrypt, Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encryptWithDES(@NotNull String data, @NotNull String key, boolean isUrlSafe) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String md5 = MD5Coder.MD5(key);
            Charset charset = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = data.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] encrypt = DESCoder.encrypt(byArray, md5);
            string = isUrlSafe ? Base64.encodeBase64URLSafeString((byte[])encrypt) : Base64.encodeBase64String((byte[])encrypt);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String decryptWithDES(@NotNull String encryptData, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encryptData, (String)"encryptData");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String md5 = MD5Coder.MD5(key);
            Charset charset = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = encryptData.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] encodeBase64 = Base64.decodeBase64((byte[])byArray);
            Intrinsics.checkNotNull((Object)encodeBase64);
            byte[] encrypt = DESCoder.decrypt(encodeBase64, md5);
            Charset charset2 = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charsetName)");
            string = new String(encrypt, charset2);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encryptWithRSA(@NotNull String data, @Nullable String key, boolean isUrlSafe) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Charset charset = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = data.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] encrypt = RSACoder.encryptByPublicKey(byArray, key);
            string = isUrlSafe ? Base64.encodeBase64URLSafeString((byte[])encrypt) : Base64.encodeBase64String((byte[])encrypt);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String decryptWithRSA(@NotNull String encryptData, @Nullable String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encryptData, (String)"encryptData");
        try {
            Charset charset = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = encryptData.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] encodeBase64 = Base64.decodeBase64((byte[])byArray);
            Intrinsics.checkNotNull((Object)encodeBase64);
            byte[] encrypt = RSACoder.decryptByPrivateKey(encodeBase64, key);
            Charset charset2 = Charset.forName(CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(charsetName)");
            string = new String(encrypt, charset2);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encryptWithMD5(@NotNull String data) {
        String string;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            string = MD5Coder.MD5(data);
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
        return string;
    }
}

