/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0007J\u001c\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcn/lnkdoc/sdk/uia/instance/bjtoon/util/encryption/AES256Coder;", "", "()V", "CIPHER_ALGORITHM", "", "KEY_ALGORITHM", "KEY_LENGTH", "", "decrypt", "", "data", "key", "encrypt", "initKey", "toKey", "Ljava/security/Key;", "awesome-uia-sdk"})
public final class AES256Coder {
    @NotNull
    public static final AES256Coder INSTANCE = new AES256Coder();
    @NotNull
    private static final String KEY_ALGORITHM = "AES";
    @NotNull
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static final int KEY_LENGTH = 256;

    private AES256Coder() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] initKey() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM, "BC");
        SecretKey secretKey = kg.generateKey();
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final Key toKey(@Nullable byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@Nullable byte[] data, @Nullable byte[] key) throws Exception {
        Key k = AES256Coder.toKey(key);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM, "BC");
        cipher.init(1, k);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@Nullable byte[] data, @Nullable byte[] key) throws Exception {
        Key k = AES256Coder.toKey(key);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, k);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }
}

