/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.wx;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.wx.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.wx.domain.RefreshToken;
import cn.lnkdoc.sdk.uia.instance.wx.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.wx.property.WxProperty;
import cn.lnkdoc.sdk.uia.instance.wx.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.wx.request.RefreshTokenRequest;
import cn.lnkdoc.sdk.uia.instance.wx.request.UserInfoRequest;
import com.alibaba.fastjson2.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcn/lnkdoc/sdk/uia/example/wx/Example;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildLoginUrl", "", "getAccessToken", "Lcn/lnkdoc/sdk/uia/instance/wx/domain/AccessToken;", "code", "getUserInfo", "Lcn/lnkdoc/sdk/uia/instance/wx/domain/UserInfo;", "accessToken", "loadProperty", "Lcn/lnkdoc/sdk/uia/instance/wx/property/WxProperty;", "main", "", "args", "", "([Ljava/lang/String;)V", "refreshToken", "Lcn/lnkdoc/sdk/uia/instance/wx/domain/RefreshToken;", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nExample.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/wx/Example\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n*L\n1#1,145:1\n588#2:146\n588#2:147\n588#2:148\n*S KotlinDebug\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/wx/Example\n*L\n39#1:146\n43#1:147\n47#1:148\n*E\n"})
public final class Example {
    @NotNull
    public static final Example INSTANCE = new Example();
    private static final Logger log = LoggerFactory.getLogger(Example.class);

    private Example() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        RefreshToken refreshToken;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        System.out.println((Object)INSTANCE.buildLoginUrl());
        String code = "";
        AccessToken accessToken2 = INSTANCE.getAccessToken(code);
        Object $this$toJSONString$iv = accessToken2;
        boolean $i$f$toJSONString = false;
        $this$toJSONString$iv = JSON.toJSONString((Object)$this$toJSONString$iv);
        System.out.println($this$toJSONString$iv);
        UserInfo userInfo = INSTANCE.getUserInfo(accessToken2);
        Object $this$toJSONString$iv2 = userInfo;
        boolean $i$f$toJSONString2 = false;
        $this$toJSONString$iv2 = JSON.toJSONString((Object)$this$toJSONString$iv2);
        System.out.println($this$toJSONString$iv2);
        RefreshToken $this$toJSONString$iv3 = refreshToken = INSTANCE.refreshToken(accessToken2);
        boolean $i$f$toJSONString3 = false;
        String string = JSON.toJSONString((Object)$this$toJSONString$iv3);
        System.out.println((Object)string);
    }

    private final WxProperty loadProperty() {
        WxProperty property = new WxProperty();
        property.setClientId("");
        property.setClientSecret("");
        property.setRedirectUri("");
        return property;
    }

    private final AccessToken getAccessToken(String code) {
        WxProperty property = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private final RefreshToken refreshToken(AccessToken accessToken2) {
        WxProperty property = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        RefreshTokenRequest request = new RefreshTokenRequest();
        AccessToken accessToken3 = accessToken2;
        Intrinsics.checkNotNull((Object)accessToken3);
        request.setBody(accessToken3.getRefreshToken());
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (RefreshToken)executeResponse.getData();
    }

    private final UserInfo getUserInfo(AccessToken accessToken2) {
        WxProperty property = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        UserInfoRequest request = new UserInfoRequest();
        UserInfoRequest.Body body = new UserInfoRequest.Body();
        AccessToken accessToken3 = accessToken2;
        body.setAccessToken(accessToken3 != null ? accessToken3.getAccessToken() : null);
        AccessToken accessToken4 = accessToken2;
        body.setOpenid(accessToken4 != null ? accessToken4.getOpenid() : null);
        request.setBody(body);
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private final String buildLoginUrl() {
        String string;
        try {
            WxProperty property = this.loadProperty();
            String redirectUri = property.getRedirectUri();
            String encode = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8.displayName());
            String state = "";
            CharSequence[] charSequenceArray = new CharSequence[]{"https://open.weixin.qq.com/connect/qrconnect?", "appid=" + property.getClientId(), "&redirect_uri=" + encode, "&response_type=code", "&scope=snsapi_login", StringUtils.isBlank((CharSequence)state) ? "" : "&state=" + state, "#wechat_redirect"};
            string = String.join((CharSequence)"", charSequenceArray);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return string;
    }
}

