/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.alipay;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.SignType;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.alipay.SignMode;
import cn.lnkdoc.sdk.uia.instance.alipay.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.alipay.domain.RefreshToken;
import cn.lnkdoc.sdk.uia.instance.alipay.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.alipay.property.AlipayProperty;
import cn.lnkdoc.sdk.uia.instance.alipay.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.alipay.request.RefreshTokenRequest;
import cn.lnkdoc.sdk.uia.instance.alipay.request.UserInfoRequest;
import com.alibaba.fastjson2.JSON;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcn/lnkdoc/sdk/uia/example/alipay/Example;", "", "()V", "logger", "Lorg/slf4j/Logger;", "authenticate", "Lcn/lnkdoc/sdk/uia/instance/alipay/domain/AccessToken;", "code", "", "buildOauthUrl", "getUserInfo", "Lcn/lnkdoc/sdk/uia/instance/alipay/domain/UserInfo;", "accessToken", "loadProperty", "Lcn/lnkdoc/sdk/uia/instance/alipay/property/AlipayProperty;", "main", "", "args", "", "([Ljava/lang/String;)V", "refresh", "Lcn/lnkdoc/sdk/uia/instance/alipay/domain/RefreshToken;", "awesome-uia-sdk"})
@SourceDebugExtension(value={"SMAP\nExample.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/alipay/Example\n+ 2 JSON.kt\ncom/alibaba/fastjson2/JSONKt\n*L\n1#1,135:1\n588#2:136\n588#2:137\n588#2:138\n*S KotlinDebug\n*F\n+ 1 Example.kt\ncn/lnkdoc/sdk/uia/example/alipay/Example\n*L\n35#1:136\n40#1:137\n45#1:138\n*E\n"})
public final class Example {
    @NotNull
    public static final Example INSTANCE = new Example();
    @NotNull
    private static final Logger logger;

    private Example() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        RefreshToken refresh;
        UserInfo userInfo;
        AccessToken accessToken2;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        System.out.println((Object)INSTANCE.buildOauthUrl());
        String code = "7f027e108af0458a906118a81441DX82";
        AccessToken $this$toJSONString$iv = accessToken2 = INSTANCE.authenticate(code);
        boolean $i$f$toJSONString = false;
        String accessTokenJSONString = JSON.toJSONString((Object)$this$toJSONString$iv);
        System.out.println((Object)accessTokenJSONString);
        UserInfo $this$toJSONString$iv2 = userInfo = INSTANCE.getUserInfo(accessToken2);
        boolean $i$f$toJSONString2 = false;
        String userInfoJSONString = JSON.toJSONString((Object)$this$toJSONString$iv2);
        System.out.println((Object)userInfoJSONString);
        RefreshToken $this$toJSONString$iv3 = refresh = INSTANCE.refresh(accessToken2);
        boolean $i$f$toJSONString3 = false;
        String string = JSON.toJSONString((Object)$this$toJSONString$iv3);
        System.out.println((Object)string);
    }

    private final AlipayProperty loadProperty() {
        AlipayProperty property = new AlipayProperty();
        property.setAppId("");
        property.setAppPrivateKey("");
        property.setAlipayPublicKey("");
        property.setSignMode(SignMode.PUBLIC_KEY.getSignMode());
        property.setSignType(SignType.RSA.getSignType());
        property.setAlipayGatewayUrl("https://openapi.alipay.com/gateway.do");
        property.setRedirectUri("");
        property.setPrintStack(true);
        return property;
    }

    private final AccessToken authenticate(String code) {
        AlipayProperty loadProperty = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(loadProperty);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private final RefreshToken refresh(AccessToken accessToken2) {
        AlipayProperty loadProperty = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(loadProperty);
        RefreshTokenRequest request = new RefreshTokenRequest();
        AccessToken accessToken3 = accessToken2;
        request.setBody(accessToken3 != null ? accessToken3.getRefreshToken() : null);
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (RefreshToken)executeResponse.getData();
    }

    private final UserInfo getUserInfo(AccessToken accessToken2) {
        AlipayProperty loadProperty = this.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(loadProperty);
        UserInfoRequest request = new UserInfoRequest();
        AccessToken accessToken3 = accessToken2;
        request.setBody(accessToken3 != null ? accessToken3.getAccessToken() : null);
        UiaResponse executeResponse = instance.getUserInfo(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private final String buildOauthUrl() {
        AlipayProperty property = this.loadProperty();
        return "https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=" + property.getAppId() + "&scope=auth_user&redirect_uri=" + URLEncoder.encode(property.getRedirectUri(), StandardCharsets.UTF_8.name()) + "&state=init";
    }

    static {
        Logger logger = LoggerFactory.getLogger(Example.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Example.logger = logger;
    }
}

