/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.jban.client;

import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.IUiaResponse;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.jban.property.JbanProperty;
import cn.lnkdoc.sdk.uia.instance.jban.util.CheckResponseUtil;
import io.vavr.Tuple;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbanUiaClient
implements IUiaClient {
    private static final Logger log = LoggerFactory.getLogger(JbanUiaClient.class);
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private JbanProperty property;

    public static JbanUiaClient getInstance(JbanProperty property) {
        JbanUiaClient client = new JbanUiaClient();
        client.property = property;
        JbanUiaClient.checkMustRequired(property);
        return client;
    }

    private JbanUiaClient() {
    }

    @Override
    public <RESP> IUiaResponse<RESP> execute(IUiaRequest request) throws UiaException {
        try {
            String string = this.sendRequest(request);
            CheckResponseUtil.check(string);
            List<IUiaConverter> converts = request.getConvert();
            Assert.required(converts, "not found converter for [" + request.getClass().getName() + "]");
            IUiaConverter convert = converts.get(0);
            Object resp = convert.convertResponse(string);
            return UiaResponse.success(resp);
        }
        catch (Exception e) {
            if (this.property.isPrintStack()) {
                log.error("", (Throwable)e);
            }
            return UiaResponse.fail(e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private String sendRequest(IUiaRequest request) {
        String string;
        Response response;
        String string2;
        boolean success;
        String logMessage;
        block11: {
            String url = request.url(this.property);
            logMessage = String.format("[%s][%s]", new Object[]{request.method(), url});
            success = false;
            string2 = "";
            IUiaConverter convert = request.getConvert().get(0);
            Request httpRequest = (Request)convert.convertRequest(Tuple.of((Object)this.property, (Object)this.client, (Object)request));
            response = this.client.newCall(httpRequest).execute();
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            string2 = responseBody.string();
            success = true;
            string = string2;
            if (response == null) break block11;
            response.close();
        }
        log.debug("{}[{}][{}]", new Object[]{logMessage, success, string2});
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (this.property.isPrintStack()) {
                            log.error("", (Throwable)e);
                        }
                        throw new UiaException(e);
                    }
                }
                catch (Throwable throwable3) {
                    log.debug("{}[{}][{}]", new Object[]{logMessage, success, string2});
                    throw throwable3;
                }
            }
        }
    }

    private static void checkMustRequired(JbanProperty property) {
        Assert.required(property, "the yztoonConfiguration is required");
        Assert.required(property.getDomain(), "the domain configuration is required");
        Assert.required(property.getClientId(), "the clientId configuration is required");
        Assert.required(property.getClientSecret(), "the clientSecret configuration is required");
        Assert.required(property.getOpenTeamId(), "the redirectUrl configuration is required");
    }
}

