/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.wx;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.wx.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.wx.domain.RefreshToken;
import cn.lnkdoc.sdk.uia.instance.wx.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.wx.property.WxProperty;
import cn.lnkdoc.sdk.uia.instance.wx.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.wx.request.RefreshTokenRequest;
import cn.lnkdoc.sdk.uia.instance.wx.request.UserInfoRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example {
    private static final Logger log = LoggerFactory.getLogger(Example.class);

    public static void main(String[] args) {
        String code = "";
        AccessToken accessToken = Example.getAccessToken(code);
        System.out.println(JSONObject.toJSONString((Object)accessToken, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        UserInfo userInfo = Example.getUserInfo(accessToken);
        System.out.println(JSONObject.toJSONString((Object)userInfo, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        RefreshToken refreshToken = Example.refreshToken(accessToken);
        System.out.println(JSONObject.toJSONString((Object)refreshToken, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
    }

    private static WxProperty loadProperty() {
        WxProperty property = new WxProperty();
        property.setClientId("");
        property.setClientSecret("");
        return property;
    }

    private static AccessToken getAccessToken(String code) {
        WxProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private static RefreshToken refreshToken(AccessToken accessToken) {
        WxProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.setBody(accessToken.getRefreshToken());
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (RefreshToken)executeResponse.getData();
    }

    private static UserInfo getUserInfo(AccessToken accessToken) {
        WxProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        UserInfoRequest request = new UserInfoRequest();
        request.setBody(new UserInfoRequest.Body(accessToken.getAccessToken(), accessToken.getOpenid()));
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private static String buildLoginUrl() {
        String redirectUri = "";
        String encode = URLEncoder.encode(redirectUri, StandardCharsets.UTF_8);
        String state = "";
        WxProperty property = Example.loadProperty();
        return String.join((CharSequence)"", new CharSequence[]{"https://open.weixin.qq.com/connect/qrconnect?", "appid=" + property.getClientId(), "&redirect_uri=" + encode, "&response_type=code", "&scope=snsapi_login", StringUtils.isBlank((CharSequence)state) ? "" : "&state=" + state, "#wechat_redirect"});
    }
}

