/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.common.util.cert;

import cn.lnkdoc.sdk.uia.common.util.cert.SavingTrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallCert {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final char SEPARATOR = File.separatorChar;
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String KEYS_STORE_NAME = "jssecacerts";
    private static final String DEFAULT_KEYS_STORE_NAME = "cacerts";
    private static final String SECURITY_CERT_HOME = System.getProperty("java.home") + SEPARATOR + "lib" + SEPARATOR + "security";
    private static final String PROJECT_HOME = System.getProperty("user.dir");

    public static void main(String[] args) throws Exception {
        String domain = "yzt.beijing.gov.cn";
        InstallCert.generateTrustStore(domain);
    }

    public static void generateTrustStore(String domain) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException {
        InstallCert.generateTrustStore(domain, null);
    }

    public static void generateTrustStore(String domain, String password) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException {
        int k;
        File dir;
        if (Objects.isNull(domain)) {
            System.err.println("domain must be not null");
            return;
        }
        String keyStoreName = KEYS_STORE_NAME;
        String certFilePath = PROJECT_HOME + SEPARATOR + keyStoreName;
        password = Objects.isNull(password) || password.trim().isEmpty() ? DEFAULT_KEYSTORE_PASSWORD : password;
        String[] hostAndPort = domain.split(":");
        String host = hostAndPort[0];
        int port = hostAndPort.length == 1 ? 443 : Integer.parseInt(hostAndPort[1]);
        char[] passwordCharArray = password.toCharArray();
        File file = new File(certFilePath);
        if (!file.isFile() && !(file = new File(dir = new File(SECURITY_CERT_HOME), keyStoreName)).isFile()) {
            file = new File(dir, DEFAULT_KEYS_STORE_NAME);
        }
        System.out.println("Loading KeyStore " + file + " ...");
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passwordCharArray);
        in.close();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ":" + port + "...");
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.setSoTimeout(10000);
        try {
            System.out.println("Starting SSL handshake...");
            socket.startHandshake();
            socket.close();
            System.out.println();
            System.out.println("No errors, certificate is already trusted");
        }
        catch (SSLException e) {
            System.err.println("====================================================================================");
            e.printStackTrace(System.out);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        X509Certificate[] chain = tm.getChain();
        if (chain == null) {
            System.err.println("Could not obtain server certificate chain");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println();
        System.out.println("Server sent " + chain.length + " certificate(s):");
        System.out.println();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = chain[i];
            System.out.println(" " + (i + 1) + " Subject " + cert.getSubjectX500Principal());
            System.out.println("  Issuer  " + cert.getSubjectX500Principal());
            sha1.update(cert.getEncoded());
            System.out.println("  sha1    " + InstallCert.toHexString(sha1.digest()));
            md5.update(cert.getEncoded());
            System.out.println("  md5    " + InstallCert.toHexString(md5.digest()));
            System.out.println();
        }
        System.out.println("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String line = reader.readLine().trim();
        try {
            k = line.isEmpty() ? 0 : Integer.parseInt(line) - 1;
        }
        catch (NumberFormatException e) {
            System.err.println("KeyStore not changed");
            return;
        }
        X509Certificate cert = chain[k];
        String alias = host + "-" + (k + 1);
        ks.setCertificateEntry(alias, cert);
        Path path = Paths.get(certFilePath, new String[0]);
        OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
        ks.store(out, passwordCharArray);
        out.close();
        System.out.println();
        System.out.println(cert);
        System.out.println();
        System.out.println("Added certificate to keystore " + certFilePath + " using alias '" + alias + "'");
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEX_DIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEX_DIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }
}

