/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.converter;

import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.instance.bjtoon.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.bjtoon.property.BjtoonProperty;
import cn.lnkdoc.sdk.uia.instance.bjtoon.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.bjtoon.response.BjtoonResponse;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption.CyptoClient;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import io.vavr.Tuple2;
import okhttp3.FormBody;

public class AccessTokenConverter
implements IUiaConverter {
    @Override
    public <T, R> T convertRequest(R body) {
        Tuple2 tuple = (Tuple2)body;
        BjtoonProperty bjtoonProperty = (BjtoonProperty)tuple._2;
        AccessTokenRequest accessTokenRequest = (AccessTokenRequest)tuple._1;
        String authToken = CyptoClient.encryptWithAES(bjtoonProperty.getClientId() + ":" + bjtoonProperty.getClientSecret() + ":" + System.currentTimeMillis(), bjtoonProperty.getClientSecret());
        return (T)new FormBody.Builder().addEncoded("client_id", bjtoonProperty.getClientId()).addEncoded("client_secret", bjtoonProperty.getClientSecret()).addEncoded("redirect_uri", bjtoonProperty.getRedirectUri()).addEncoded("grant_code", accessTokenRequest.body()).addEncoded("grant_type", bjtoonProperty.getGrantType()).addEncoded("auth_token", authToken).addEncoded("scope", bjtoonProperty.getScope()).addEncoded("toonType", accessTokenRequest.getToonType()).addEncoded("state", accessTokenRequest.getState()).addEncoded("inType", accessTokenRequest.getInType()).addEncoded("localCheck", accessTokenRequest.getLocalCheck()).build();
    }

    @Override
    public <T, R> T convertResponse(R body) {
        Tuple2 tuple = (Tuple2)body;
        BjtoonResponse response = (BjtoonResponse)JSONObject.parseObject((String)((String)tuple._1), (TypeReference)new TypeReference<BjtoonResponse<AccessToken>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
        AccessToken data = (AccessToken)response.getData();
        return (T)data;
    }

    @Override
    public String name() {
        return AccessTokenRequest.class.getName();
    }
}

