/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.client;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.bjtoon.property.BjtoonProperty;
import cn.lnkdoc.sdk.uia.instance.bjtoon.util.CheckResponseUtil;
import io.vavr.Tuple;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjtoonUiaClient
implements IUiaClient {
    private static final Logger log = LoggerFactory.getLogger(BjtoonUiaClient.class);
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private BjtoonProperty property;

    public static BjtoonUiaClient getInstance(BjtoonProperty property) {
        BjtoonUiaClient client = new BjtoonUiaClient();
        client.property = property;
        BjtoonUiaClient.checkMustRequired(property);
        return client;
    }

    private BjtoonUiaClient() {
    }

    public <RESP> UiaResponse<RESP> execute(IUiaRequest request) throws UiaException {
        try {
            String string = this.sendRequest(request);
            CheckResponseUtil.check(string);
            IUiaConverter converter = request.getConvert().stream().filter(it -> it.name().equals(request.getClass().getName() + "")).findFirst().orElseThrow(() -> new UiaException("not found converter for [" + request.getClass().getName() + "]"));
            Assert.required(converter, "not found converter for [" + request.getClass().getName() + "]");
            Object data = converter.convertResponse(Tuple.of((Object)string, (Object)this.property));
            return UiaResponse.success(data);
        }
        catch (Exception e) {
            if (this.property.isPrintStack()) {
                log.error("", (Throwable)e);
            }
            return UiaResponse.fail(e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private String sendRequest(IUiaRequest request) {
        String string;
        Response response;
        String string2;
        boolean success;
        String logMessage;
        block10: {
            IUiaConverter converter = request.getConvert().stream().filter(it -> it.name().equals(request.getClass().getName())).findFirst().orElseThrow(() -> new UiaException("not found converter for [" + request.getClass().getName() + "]"));
            Assert.required(converter, "not found converter for [" + request.getClass().getName() + "]");
            String url = request.url(this.property);
            logMessage = String.format("[%s][%s]", new Object[]{request.method(), url});
            success = false;
            string2 = "";
            RequestBody body = (RequestBody)converter.convertRequest(Tuple.of((Object)request, (Object)this.property));
            Request httpRequest = new Request.Builder().url(url).method(request.method().getMethod(), (RequestBody)(HttpMethod.POST.equals((Object)request.method()) ? body : null)).build();
            response = this.client.newCall(httpRequest).execute();
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            string2 = responseBody.string();
            success = true;
            string = string2;
            if (response == null) break block10;
            response.close();
        }
        log.debug("{}[{}][{}]", new Object[]{logMessage, success, string2});
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new UiaException(e);
                    }
                }
                catch (Throwable throwable3) {
                    log.debug("{}[{}][{}]", new Object[]{logMessage, success, string2});
                    throw throwable3;
                }
            }
        }
    }

    private static void checkMustRequired(BjtoonProperty property) {
        Assert.required(property, "the yztoonConfiguration is required");
        Assert.required(property.getDomain(), "the domain configuration is required");
        Assert.required(property.getClientId(), "the clientId configuration is required");
        Assert.required(property.getClientSecret(), "the clientSecret configuration is required");
        Assert.required(property.getRegisterPath(), "the registerPath configuration is required");
    }
}

