/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.yztoon;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.yztoon.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.yztoon.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.yztoon.property.YztoonProperty;
import cn.lnkdoc.sdk.uia.instance.yztoon.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.yztoon.request.LogoutRequest;
import cn.lnkdoc.sdk.uia.instance.yztoon.request.UserInfoRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example {
    private static final Logger log = LoggerFactory.getLogger(Example.class);

    public static void main(String[] args) {
        String code = "";
        AccessToken accessToken = Example.authenticate(code);
        System.out.println(JSONObject.toJSONString((Object)accessToken, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        UserInfo userInfo = Example.getUserInfo(accessToken);
        System.out.println(JSONObject.toJSONString((Object)userInfo, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        Object logout = Example.logout();
        System.out.println(logout);
    }

    private static YztoonProperty loadProperty() {
        YztoonProperty property = new YztoonProperty();
        property.setDomain("https://yzt.beijing.gov.cn/am");
        property.setClientId("");
        property.setClientSecret("");
        property.setRedirectUrl("");
        property.setPrintStack(true);
        property.setTrustDomain(true);
        return property;
    }

    private static AccessToken authenticate(String code) {
        YztoonProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private static UserInfo getUserInfo(AccessToken accessToken) {
        YztoonProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        UserInfoRequest request = new UserInfoRequest();
        request.setBody(accessToken.getAccessToken());
        UiaResponse executeResponse = instance.getUserInfo(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private static Object logout() {
        LogoutRequest request;
        YztoonProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        UiaResponse executeResponse = instance.getAccessToken(request = new LogoutRequest());
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return executeResponse.getData();
    }
}

