/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.jban;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.jban.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.jban.domain.MobileInfo;
import cn.lnkdoc.sdk.uia.instance.jban.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.jban.property.JbanProperty;
import cn.lnkdoc.sdk.uia.instance.jban.request.JbanAccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.jban.request.JbanMobileMd5UserRequest;
import cn.lnkdoc.sdk.uia.instance.jban.request.JbanUserInfoRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example {
    private static final Logger log = LoggerFactory.getLogger(Example.class);

    public static void main(String[] args) {
        String code = "";
        AccessToken accessToken = Example.authenticate(code);
        System.out.println(JSONObject.toJSONString((Object)accessToken, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        UserInfo userInfo = Example.getUserInfo(accessToken);
        System.out.println(JSONObject.toJSONString((Object)userInfo, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        String mobile = "";
        MobileInfo openid = Example.getOpenid(mobile);
        System.out.println(JSONObject.toJSONString((Object)openid, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
    }

    private static JbanProperty loadProperty() {
        JbanProperty property = new JbanProperty();
        property.setDomain("https://open.jzb.beijing.gov.cn");
        property.setClientId("");
        property.setClientSecret("");
        property.setOpenTeamId("");
        return property;
    }

    private static AccessToken authenticate(String code) {
        JbanProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        JbanAccessTokenRequest request = new JbanAccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            log.error(executeResponse.getMessage());
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private static UserInfo getUserInfo(AccessToken accessToken) {
        JbanProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        JbanUserInfoRequest request = new JbanUserInfoRequest();
        request.setBody(accessToken.getAccessToken());
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            log.error(executeResponse.getMessage());
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }

    private static MobileInfo getOpenid(String mobile) {
        JbanProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        JbanMobileMd5UserRequest request = new JbanMobileMd5UserRequest();
        request.setBody(mobile);
        UiaResponse executeResponse = instance.execute(request);
        if (executeResponse.isFailed()) {
            log.error(executeResponse.getMessage());
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (MobileInfo)executeResponse.getData();
    }
}

