package cn.lnkdoc.sdk.uia.instance.bjtoon.util.encryption;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;


/**
 * @author langkye
 */
@SuppressWarnings(value = {"ALL"})
public class RSACoder {
    
    /**
     * KEY_ALGORITHM
     */
    public static final String KEY_ALGORITHM = "RSA";
    /**
     * SIGNATURE_ALGORITHM
     */
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    /**
     * PUBLIC_KEY
     */
    private static final String PUBLIC_KEY = "RSAPublicKey";
    /**
     * PRIVATE_KEY
     */
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    /**
     * MAX_ENCRYPT_BLOCK
     */
    private static final int MAX_ENCRYPT_BLOCK = 117;
    /**
     * MAX_DECRYPT_BLOCK
     */
    private static final int MAX_DECRYPT_BLOCK = 128;

    /**
     * sign
     * 
     * @param data data
     * @param privateKey privateKey
     * @return result
     * @throws Exception ex
     */
    public static String sign(byte[] data, String privateKey) throws Exception {
        // 解密由base64编码的私钥  
        byte[] keyBytes = Base64.decodeBase64(privateKey);  
  
        // 构造PKCS8EncodedKeySpec对象  
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);  
  
        // KEY_ALGORITHM 指定的加密算法  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
  
        // 取私钥匙对象  
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);  
  
        // 用私钥对信息生成数字签名  
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);  
        signature.initSign(priKey);  
        signature.update(data);  
  
        return Base64.encodeBase64String(signature.sign());  
    }

    /**
     * vierfy
     * 
     * @param data data
     * @param publicKey publicKey
     * @param sign sign
     * @return result
     * @throws Exception ex
     */
    public static boolean verify(byte[] data, String publicKey, String sign)
            throws Exception {  
  
        // 解密由base64编码的公钥  
        byte[] keyBytes = Base64.decodeBase64(publicKey);  
  
        // 构造X509EncodedKeySpec对象  
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);  
  
        // KEY_ALGORITHM 指定的加密算法  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
  
        // 取公钥匙对象  
        PublicKey pubKey = keyFactory.generatePublic(keySpec);  
  
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);  
        signature.initVerify(pubKey);  
        signature.update(data);  
  
        // 验证签名是否正常  
        return signature.verify(Base64.decodeBase64(sign));  
    }

    /**
     * decrypt
     * 
     * @param data data
     * @param key key
     * @return decrypt data
     * @throws Exception ex
     */
    public static byte[] decryptByPrivateKey(byte[] data, String key)
            throws Exception {  
    	byte[] keyBytes = Base64.decodeBase64(key);  
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
        Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);  
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());  
        cipher.init(Cipher.DECRYPT_MODE, privateK);  
        int inputLen = data.length;  
        ByteArrayOutputStream out = new ByteArrayOutputStream();  
        int offSet = 0;  
        byte[] cache;  
        int i = 0;  
        // 对数据分段解密  
        while (inputLen - offSet > 0) {  
            if (inputLen - offSet > MAX_DECRYPT_BLOCK) {  
                cache = cipher.doFinal(data, offSet, MAX_DECRYPT_BLOCK);  
            } else {  
                cache = cipher.doFinal(data, offSet, inputLen - offSet);  
            }  
            out.write(cache, 0, cache.length);  
            i++;  
            offSet = i * MAX_DECRYPT_BLOCK;  
        }  
        byte[] decryptedData = out.toByteArray();  
        out.close();  
        return decryptedData;  
    }

    /**
     * decrypt
     * 
     * @param data data
     * @param key key
     * @return decrypt data
     * @throws Exception ex
     */
    public static byte[] decryptByPublicKey(byte[] data, String key)
            throws Exception {  
    	byte[] keyBytes = Base64.decodeBase64(key);  
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
        Key publicK = keyFactory.generatePublic(x509KeySpec);  
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());  
        cipher.init(Cipher.DECRYPT_MODE, publicK);  
        int inputLen = data.length;  
        ByteArrayOutputStream out = new ByteArrayOutputStream();  
        int offSet = 0;  
        byte[] cache;  
        int i = 0;  
        // 对数据分段解密  
        while (inputLen - offSet > 0) {  
            if (inputLen - offSet > MAX_DECRYPT_BLOCK) {  
                cache = cipher.doFinal(data, offSet, MAX_DECRYPT_BLOCK);  
            } else {  
                cache = cipher.doFinal(data, offSet, inputLen - offSet);  
            }  
            out.write(cache, 0, cache.length);  
            i++;  
            offSet = i * MAX_DECRYPT_BLOCK;  
        }  
        byte[] decryptedData = out.toByteArray();  
        out.close();  
        return decryptedData;  
    }

    /**
     * encrypt 
     * 
     * @param data data
     * @param key key
     * @return encrypt data
     * @throws Exception ex
     */
    public static byte[] encryptByPublicKey(byte[] data, String key)
            throws Exception {  
    	byte[] keyBytes = Base64.decodeBase64(key);  
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
        Key publicK = keyFactory.generatePublic(x509KeySpec);  
        // 对数据加密  
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());  
        cipher.init(Cipher.ENCRYPT_MODE, publicK);  
        int inputLen = data.length;  
        ByteArrayOutputStream out = new ByteArrayOutputStream();  
        int offSet = 0;  
        byte[] cache;  
        int i = 0;  
        // 对数据分段加密  
        while (inputLen - offSet > 0) {  
            if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {  
                cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);  
            } else {  
                cache = cipher.doFinal(data, offSet, inputLen - offSet);  
            }  
            out.write(cache, 0, cache.length);  
            i++;  
            offSet = i * MAX_ENCRYPT_BLOCK;  
        }  
        byte[] encryptedData = out.toByteArray();  
        out.close();  
        return encryptedData;  
    }

    /**
     * encrypt 
     * 
     * @param data data
     * @param key key
     * @return encrypt data
     * @throws Exception ex
     */
    public static byte[] encryptByPrivateKey(byte[] data, String key)
            throws Exception {  
    	byte[] keyBytes = Base64.decodeBase64(key);  
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);  
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);  
        Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);  
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());  
        cipher.init(Cipher.ENCRYPT_MODE, privateK);  
        int inputLen = data.length;  
        ByteArrayOutputStream out = new ByteArrayOutputStream();  
        int offSet = 0;  
        byte[] cache;  
        int i = 0;  
        // 对数据分段加密  
        while (inputLen - offSet > 0) {  
            if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {  
                cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);  
            } else {  
                cache = cipher.doFinal(data, offSet, inputLen - offSet);  
            }  
            out.write(cache, 0, cache.length);  
            i++;  
            offSet = i * MAX_ENCRYPT_BLOCK;  
        }  
        byte[] encryptedData = out.toByteArray();  
        out.close();  
        return encryptedData;  
    }

    /**
     * getter
     * 
     * @param keyMap km
     * @return pk
     */
    public static String getPrivateKey(Map<String, Object> keyMap) {  
        Key key = (Key) keyMap.get(PRIVATE_KEY);  
        String privateKey = Base64.encodeBase64String(key.getEncoded());
        //String privateKey = new String(key.getEncoded(),"iso-8859-1");
        return privateKey;
    }

    /**
     * getter
     * 
     * @param keyMap km
     * @return pk
     */
    public static String getPublicKey(Map<String, Object> keyMap) {  
        Key key = (Key) keyMap.get(PUBLIC_KEY);  
        String publicKey = Base64.encodeBase64String(key.getEncoded());
        //String publicKey = new String(key.getEncoded(), "iso-8859-1");
        return publicKey;  
    }

    /**
     * init
     * 
     * @return km
     * @throws Exception ex
     */
    public static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator  
                .getInstance(KEY_ALGORITHM);  
        keyPairGen.initialize(1024);  
  
        KeyPair keyPair = keyPairGen.generateKeyPair();  
  
        // 公钥  
        RSAPublicKey publicKey = (RSAPublicKey) keyPair.getPublic();  
  
        // 私钥  
        RSAPrivateKey privateKey = (RSAPrivateKey) keyPair.getPrivate();  
  
        Map<String, Object> keyMap = new HashMap<String, Object>(2);  
  
        keyMap.put(PUBLIC_KEY, publicKey);  
        keyMap.put(PRIVATE_KEY, privateKey);  
        return keyMap;
    }
}