/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.example.bjtoon;

import cn.lnkdoc.sdk.uia.UiaSdkInstance;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.bjtoon.domain.AccessToken;
import cn.lnkdoc.sdk.uia.instance.bjtoon.domain.UserInfo;
import cn.lnkdoc.sdk.uia.instance.bjtoon.property.BjtoonProperty;
import cn.lnkdoc.sdk.uia.instance.bjtoon.request.AccessTokenRequest;
import cn.lnkdoc.sdk.uia.instance.bjtoon.request.UserInfoRequest;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Example {
    private static final Logger log = LoggerFactory.getLogger(Example.class);

    public static void main(String[] args) {
        String code = "";
        AccessToken accessToken = Example.authenticate(code);
        String acessTokenJSONString = JSONObject.toJSONString((Object)accessToken, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        System.out.println(acessTokenJSONString);
        UserInfo userInfo = Example.getUserInfo(accessToken);
        String userInfoJSONString = JSONObject.toJSONString((Object)userInfo, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        System.out.println(userInfoJSONString);
    }

    private static BjtoonProperty loadProperty() {
        BjtoonProperty property = new BjtoonProperty();
        property.setDomain("https://bjt.beijing.gov.cn/renzheng");
        property.setClientId("");
        property.setClientSecret("");
        return property;
    }

    private static AccessToken authenticate(String code) {
        BjtoonProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        AccessTokenRequest request = new AccessTokenRequest();
        request.setBody(code);
        UiaResponse executeResponse = instance.getAccessToken(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (AccessToken)executeResponse.getData();
    }

    private static UserInfo getUserInfo(AccessToken accessToken) {
        BjtoonProperty property = Example.loadProperty();
        ISdkInstance instance = UiaSdkInstance.getInstance(property);
        UserInfoRequest request = new UserInfoRequest();
        request.setBody(accessToken.getAccessToken());
        UiaResponse executeResponse = instance.getUserInfo(request);
        if (executeResponse.isFailed()) {
            throw new RuntimeException(executeResponse.getMessage());
        }
        return (UserInfo)executeResponse.getData();
    }
}

