/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.yztoon.client;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.IUiaResponse;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.yztoon.property.YztoonProperty;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YztoonUiaClient
implements IUiaClient {
    private static final Logger log = LoggerFactory.getLogger(YztoonUiaClient.class);
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private YztoonProperty property;

    private YztoonUiaClient() {
    }

    public static YztoonUiaClient getInstance(YztoonProperty property) {
        YztoonUiaClient uiaClient = new YztoonUiaClient();
        uiaClient.property = property;
        YztoonUiaClient.checkMustRequired(property);
        return uiaClient;
    }

    @Override
    public <RESP> IUiaResponse<RESP> execute(IUiaRequest request) throws UiaException {
        try {
            String string = this.sendRequest(request);
            List<IUiaConverter> converters = request.getConvert();
            Assert.required(converters, "not found converter for [" + request.getClass().getName() + "]");
            IUiaConverter converter = converters.get(0);
            Object t = converter.convertResponse(string);
            return UiaResponse.success(t);
        }
        catch (Exception e) {
            return UiaResponse.fail(e.getMessage());
        }
    }

    private static void checkMustRequired(YztoonProperty property) {
        Assert.required(property, "the yztoonConfiguration is required");
        Assert.required(property.getDomain(), "the domain configuration is required");
        Assert.required(property.getClientId(), "the clientId configuration is required");
        Assert.required(property.getClientSecret(), "the clientSecret configuration is required");
        Assert.required(property.getRedirectUrl(), "the redirectUrl configuration is required");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendRequest(IUiaRequest request) {
        String url = request.url(this.property);
        String logMessage = String.format("[%s][%s]", new Object[]{request.method(), url});
        log.debug(logMessage);
        MediaType mediaType = MediaType.parse((String)ContentType.TEXT_PLAIN.getMimeType());
        RequestBody body = RequestBody.create((String)"", (MediaType)mediaType);
        Request httpRequest = new Request.Builder().url(url).method(request.method().getMethod(), (RequestBody)(HttpMethod.POST.equals((Object)request.method()) ? body : null)).build();
        try (Response response = this.client.newCall(httpRequest).execute();){
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            String string = responseBody.string();
            return string;
        }
        catch (Exception e) {
            log.error(logMessage + "[errorMessage:{}]", (Object)e.getMessage());
            throw new UiaException(e);
        }
    }
}

