/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.jban.util;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.jban.domain.AppAccessToken;
import cn.lnkdoc.sdk.uia.instance.jban.domain.TeamAccessToken;
import cn.lnkdoc.sdk.uia.instance.jban.property.JbanProperty;
import cn.lnkdoc.sdk.uia.instance.jban.response.JbanResponse;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUtil {
    private static final Logger log = LoggerFactory.getLogger(ApiUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTeamAccessToken(JbanProperty property, OkHttpClient client) {
        String accessToken = ApiUtil.getAppAccessToken(property, client);
        String url = String.join((CharSequence)"", property.getDomain(), property.getTeamAccessTokenPath());
        String logMessage = String.format("[%s][%s]", HttpMethod.POST.getMethod(), url);
        log.debug(logMessage);
        MediaType mediaType = MediaType.parse((String)ContentType.APPLICATION_JSON.getMimeType());
        JSONObject reqBody = new JSONObject();
        reqBody.put((Object)"appAccessToken", (Object)accessToken);
        reqBody.put((Object)"openTeamId", (Object)property.getOpenTeamId());
        RequestBody body = RequestBody.create((String)reqBody.toJSONString(new JSONWriter.Feature[0]), (MediaType)mediaType);
        Request httpRequest = new Request.Builder().url(url).method(HttpMethod.POST.getMethod(), body).build();
        try (Response response = client.newCall(httpRequest).execute();){
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            JbanResponse jbanResponse = (JbanResponse)JSONObject.parseObject((String)responseBody.string(), (TypeReference)new TypeReference<JbanResponse<TeamAccessToken>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            boolean success = Integer.valueOf("0").equals(jbanResponse.getCode());
            if (success) {
                String string = ((TeamAccessToken)jbanResponse.getData()).getTeamAccessToken();
                return string;
            }
            throw new UiaException(jbanResponse.getMsg());
        }
        catch (UiaException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(logMessage + "[errorMessage:{}]", (Object)e.getMessage());
            throw new UiaException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAppAccessToken(JbanProperty property, OkHttpClient client) {
        String url = String.join((CharSequence)"", property.getDomain(), property.getAppAccessTokenPath());
        String logMessage = String.format("[%s][%s]", HttpMethod.POST.getMethod(), url);
        log.debug(logMessage);
        MediaType mediaType = MediaType.parse((String)ContentType.APPLICATION_JSON.getMimeType());
        JSONObject reqBody = new JSONObject();
        reqBody.put((Object)"appKey", (Object)property.getClientId());
        reqBody.put((Object)"appSecret", (Object)property.getClientSecret());
        RequestBody body = RequestBody.create((String)reqBody.toJSONString(new JSONWriter.Feature[0]), (MediaType)mediaType);
        Request httpRequest = new Request.Builder().url(url).method(HttpMethod.POST.getMethod(), body).build();
        try (Response response = client.newCall(httpRequest).execute();){
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            JbanResponse jbanResponse = (JbanResponse)JSONObject.parseObject((String)responseBody.string(), (TypeReference)new TypeReference<JbanResponse<AppAccessToken>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            boolean success = Integer.valueOf("0").equals(jbanResponse.getCode());
            if (success) {
                String string = ((AppAccessToken)jbanResponse.getData()).getAppAccessToken();
                return string;
            }
            throw new UiaException(jbanResponse.getMsg());
        }
        catch (UiaException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(logMessage + "[errorMessage:{}]", (Object)e.getMessage());
            throw new UiaException(e);
        }
    }
}

