/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance.bjtoon.client;

import cn.lnkdoc.sdk.uia.common.HttpMethod;
import cn.lnkdoc.sdk.uia.common.client.IUiaClient;
import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import cn.lnkdoc.sdk.uia.common.response.UiaResponse;
import cn.lnkdoc.sdk.uia.common.util.Assert;
import cn.lnkdoc.sdk.uia.instance.bjtoon.UiaConstants;
import cn.lnkdoc.sdk.uia.instance.bjtoon.property.BjtoonProperty;
import cn.lnkdoc.sdk.uia.instance.bjtoon.response.BjtoonResponse;
import io.vavr.Tuple;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjtoonUiaClient
implements IUiaClient {
    private static final Logger log = LoggerFactory.getLogger(BjtoonUiaClient.class);
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    private BjtoonProperty property;

    public static BjtoonUiaClient getInstance(BjtoonProperty property) {
        BjtoonUiaClient client = new BjtoonUiaClient();
        client.property = property;
        BjtoonUiaClient.checkMustRequired(property);
        return client;
    }

    private BjtoonUiaClient() {
    }

    public <RESP> UiaResponse<RESP> execute(IUiaRequest request) throws UiaException {
        try {
            boolean isSuccess;
            String string = this.sendRequest(request);
            IUiaConverter converter = request.getConvert().stream().filter(it -> it.name().equals(request.getClass().getName() + "")).findFirst().orElseThrow(() -> new UiaException("not found converter for [" + request.getClass().getName() + "]"));
            Assert.required(converter, "not found converter for [" + request.getClass().getName() + "]");
            BjtoonResponse responseWrapper = (BjtoonResponse)converter.convertResponse(Tuple.of((Object)string, (Object)this.property));
            Object data = responseWrapper.getData();
            boolean bl = isSuccess = UiaConstants.RETURN_CODE_SUCCESS.getCode().equals(responseWrapper.getMeta().getCode()) && data != null;
            if (isSuccess) {
                return UiaResponse.success(data);
            }
            return UiaResponse.fail(responseWrapper.getMeta().getMessage());
        }
        catch (Exception e) {
            log.error("[errorMessage:{}]", (Object)e.getMessage(), (Object)e);
            return UiaResponse.fail(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendRequest(IUiaRequest request) {
        IUiaConverter converter = request.getConvert().stream().filter(it -> it.name().equals(request.getClass().getName())).findFirst().orElseThrow(() -> new UiaException("not found converter for [" + request.getClass().getName() + "]"));
        Assert.required(converter, "not found converter for [" + request.getClass().getName() + "]");
        String url = request.url(this.property);
        String logMessage = String.format("[%s][%s]", new Object[]{request.method(), url});
        log.debug(logMessage);
        RequestBody body = (RequestBody)converter.convertRequest(Tuple.of((Object)request, (Object)this.property));
        Request httpRequest = new Request.Builder().url(url).method(request.method().getMethod(), (RequestBody)(HttpMethod.POST.equals((Object)request.method()) ? body : null)).build();
        try (Response response = this.client.newCall(httpRequest).execute();){
            ResponseBody responseBody = response.body();
            Assert.required(responseBody, "\u8bf7\u6c42\u65e0\u54cd\u5e94\u5185\u5bb9\uff1a[" + url + "]");
            String string = responseBody.string();
            return string;
        }
        catch (Exception e) {
            throw new UiaException(e);
        }
    }

    private static void checkMustRequired(BjtoonProperty property) {
        Assert.required(property, "the yztoonConfiguration is required");
        Assert.required(property.getDomain(), "the domain configuration is required");
        Assert.required(property.getClientId(), "the clientId configuration is required");
        Assert.required(property.getClientSecret(), "the clientSecret configuration is required");
        Assert.required(property.getRegisterPath(), "the registerPath configuration is required");
    }
}

