/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.instance;

import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.property.IUiaProperty;
import cn.lnkdoc.sdk.uia.instance.ISdkInstance;
import cn.lnkdoc.sdk.uia.instance.bjtoon.BjtoonSdkInstance;
import cn.lnkdoc.sdk.uia.instance.bjtoon.property.BjtoonProperty;
import cn.lnkdoc.sdk.uia.instance.jban.JbanSdkInstance;
import cn.lnkdoc.sdk.uia.instance.jban.property.JbanProperty;
import cn.lnkdoc.sdk.uia.instance.yztoon.YztoonSdkInstance;
import cn.lnkdoc.sdk.uia.instance.yztoon.property.YztoonProperty;
import io.vavr.Function1;
import java.io.Serializable;

public enum Instance {
    YZTOON((Function1<IUiaProperty, ISdkInstance>)((Function1 & Serializable)Instance::yztoon), YztoonProperty.class),
    BJTOON((Function1<IUiaProperty, ISdkInstance>)((Function1 & Serializable)Instance::bjtoon), BjtoonProperty.class),
    JBAN((Function1<IUiaProperty, ISdkInstance>)((Function1 & Serializable)Instance::jban), JbanProperty.class);

    private final Function1<IUiaProperty, ISdkInstance> function;
    private final Class propertyClazz;

    private static YztoonSdkInstance yztoon(IUiaProperty property) {
        return new YztoonSdkInstance((YztoonProperty)property);
    }

    private static BjtoonSdkInstance bjtoon(IUiaProperty property) {
        return new BjtoonSdkInstance((BjtoonProperty)property);
    }

    private static JbanSdkInstance jban(IUiaProperty property) {
        return new JbanSdkInstance((JbanProperty)property);
    }

    private Instance(Function1<IUiaProperty, ISdkInstance> function, Class propertyClazz) {
        this.function = function;
        this.propertyClazz = propertyClazz;
    }

    public Function1<IUiaProperty, ISdkInstance> getFunction() {
        return this.function;
    }

    public Class getPropertyClazz() {
        return this.propertyClazz;
    }

    public static Instance of(String name) {
        for (Instance instance : Instance.values()) {
            if (!instance.toString().equals(name)) continue;
            return instance;
        }
        throw new UiaException("not match instance for \u201c" + name + "\u201d");
    }

    public static Instance of(Class propertyClazz) {
        for (Instance instance : Instance.values()) {
            if (!instance.propertyClazz.equals(propertyClazz)) continue;
            return instance;
        }
        throw new UiaException("un support property type : " + propertyClazz);
    }
}

