/*
 * Decompiled with CFR 0.152.
 */
package cn.lnkdoc.sdk.uia.common.request;

import cn.lnkdoc.sdk.uia.common.convert.IUiaConverter;
import cn.lnkdoc.sdk.uia.common.exception.UiaException;
import cn.lnkdoc.sdk.uia.common.request.IUiaRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractUiaRequest
implements IUiaRequest {
    protected static final Map<String, List<IUiaConverter>> converters = new HashMap<String, List<IUiaConverter>>();

    @Override
    public <T, R> List<IUiaConverter> getConvert() {
        List<IUiaConverter> converts = converters.get(this.getClass().getName());
        if (CollectionUtils.isEmpty(converts)) {
            AbstractUiaRequest.loadConverters();
        }
        if (CollectionUtils.isEmpty(converts = converters.get(this.getClass().getName()))) {
            List<IUiaConverter> finalConverts = converts = new ArrayList<IUiaConverter>();
            converters.forEach((k, v) -> {
                if (k != null && k.contains(this.getClass().getName())) {
                    finalConverts.addAll((Collection<IUiaConverter>)v);
                }
            });
        }
        if (CollectionUtils.isEmpty(converts)) {
            throw new UiaException("convert not found by name : " + this.getClass().getName());
        }
        return converts;
    }

    private static void loadConverters() {
        ServiceLoader<IUiaConverter> parseProviders = ServiceLoader.load(IUiaConverter.class);
        if (!parseProviders.iterator().hasNext()) {
            throw new UiaException("not fund parser provider for IConverter");
        }
        for (IUiaConverter converter : parseProviders) {
            List<IUiaConverter> converts = converters.get(converter.name());
            if (CollectionUtils.isEmpty(converts)) {
                converts = new ArrayList<IUiaConverter>();
            }
            converts.add(converter);
            converters.put(converter.name(), converts);
        }
    }
}

