/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    private RequestUtils() {
    }

    public static HttpServletRequest getCurrentRequest() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.state((boolean)(attrs instanceof ServletRequestAttributes), (String)"No current ServletRequestAttributes");
        return ((ServletRequestAttributes)attrs).getRequest();
    }

    public static <T> String request(String method, String url, Map<String, String> headers, T body) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonStringBody = body == null ? "" : objectMapper.writeValueAsString(body);
            return RequestUtils.request(method, url, headers, jsonStringBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String request(String method, String url, Map<String, String> headers, String jsonStringBody) {
        try {
            String line;
            method = method.toUpperCase();
            URL thisUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)thisUrl.openConnection();
            connection.setRequestMethod(method);
            headers.forEach(connection::setRequestProperty);
            connection.setDoOutput(true);
            if (jsonStringBody != null && !jsonStringBody.isEmpty()) {
                OutputStream os = connection.getOutputStream();
                byte[] outputInBytes = jsonStringBody.getBytes(StandardCharsets.UTF_8);
                os.write(outputInBytes);
                os.close();
            }
            InputStream in = connection.getInputStream();
            InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            in.close();
            isr.close();
            br.close();
            connection.disconnect();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

