/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.util;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.exception.InvalidToken;
import cn.ljserver.tool.weboffice.v3.util.DateUtils;
import cn.ljserver.tool.weboffice.v3.util.SignUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class HeaderUtils {
    private HeaderUtils() {
    }

    public static Map<String, String> header(String method, String uri, String body, String appid, String secret) {
        HashMap<String, String> header = new HashMap<String, String>();
        String md5 = SignUtils.md5(method, uri, body);
        String data = DateUtils.date();
        header.put("Content-Md5", md5);
        header.put("Content-Type", "application/json");
        header.put("Date", data);
        header.put("Authorization", SignUtils.sign(appid, secret, data, md5));
        return header;
    }

    public static String getHeaderContentMd5(HttpServletRequest request) {
        return request.getHeader("Content-Md5");
    }

    public static String getHeaderContentType(HttpServletRequest request) {
        return request.getHeader("Content-Type");
    }

    public static String getHeaderDate(HttpServletRequest request) {
        return request.getHeader("Date");
    }

    public static String getHeaderAuthorization(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public static String getWebOfficeToken(HttpServletRequest request) {
        String token = request.getHeader("X-Weboffice-Token");
        if (Objects.isNull(token)) {
            throw new InvalidToken("weboffice token is required");
        }
        return token;
    }

    public static String getAppId(HttpServletRequest request) {
        String appId = request.getHeader("X-App-Id");
        if (Objects.isNull(appId)) {
            throw new InvalidArgument("app id is required");
        }
        return appId;
    }

    public static String getRequestId(HttpServletRequest request) {
        String requestId = request.getHeader("X-Request-Id");
        if (Objects.isNull(requestId)) {
            return "";
        }
        return requestId;
    }

    public static String getUserQuery(HttpServletRequest request) {
        String userQuery = request.getHeader("X-User-Query");
        if (Objects.isNull(userQuery)) {
            return "";
        }
        return userQuery;
    }
}

