/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.util;

import cn.ljserver.tool.weboffice.v3.exception.FileTypeNotSupport;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class FileUtils {
    public static final String S = "s";
    public static final String W = "w";
    public static final String P = "p";
    public static final String F = "f";
    public static final String O = "o";
    public static final String D = "d";
    public static final String[] templateTypes = new String[]{"s", "w", "p", "d", "o"};
    public static final String[] imgConvertToDocumentTypes = new String[]{"png", "jpg", "jpeg", "bmp", "tif", "tiff", "gif"};
    public static final String[] convertToDocumentTypes = new String[]{"docx", "xlsx", "pptx"};
    public static final String[] documentConvertTypes = new String[]{"docx", "xlsx", "pptx", "doc", "xls", "ppt", "pdf"};
    public static final String[] excelToXlsxTypes = new String[]{"et", "ett", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "csv", "ets", "eto", "tpxls", "log"};
    public static final String[] wordToDocxTypes = new String[]{"doc", "docx", "dot", "dotx", "dotm", "rtf", "mht", "html", "txt", "xml"};
    public static final String[] powerPointToPptxTypes = new String[]{"ppt", "pptx", "pptm", "pptm", "ppsm", "pps", "potx", "potm", "dpt", "dps", "pot", "ppsx"};
    public static final String[] excelPreviewTypes = new String[]{"et", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "csv", "ett"};
    public static final String[] wordPreviewTypes = new String[]{"doc", "docx", "txt", "dot", "wps", "wpt", "dotx", "docm", "dotm", "xml", "rtf", "mht", "html"};
    public static final String[] powerPointPreviewTypes = new String[]{"ppt", "pptx", "pptm", "pptm", "ppsm", "pps", "potx", "potm", "dpt", "dps", "pot", "ppsx"};
    public static final String[] pdfPreviewTypes = new String[]{"pdf"};
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String[] imgTypes = new String[]{"jpg", "png"};
    public static final Map<String, String> officeTypes;

    private FileUtils() {
    }

    public static void typeMatchCheck(String[] types, String inputType) {
        boolean noneMatch = Arrays.stream(types).noneMatch(type -> type.equalsIgnoreCase(inputType));
        if (noneMatch) {
            throw new FileTypeNotSupport();
        }
    }

    public static String suffix(String filePathOrUrl) {
        String fileName = FileUtils.name(filePathOrUrl);
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1 && dotIndex < fileName.length() - 1) {
            return fileName.substring(dotIndex + 1).toLowerCase();
        }
        throw new FileTypeNotSupport();
    }

    public static String name(String filePathOrUrl) {
        if (filePathOrUrl == null || filePathOrUrl.isEmpty()) {
            throw new FileTypeNotSupport();
        }
        String fileName = filePathOrUrl.contains("?") ? filePathOrUrl.substring(filePathOrUrl.lastIndexOf(47) + 1, filePathOrUrl.indexOf(63)) : filePathOrUrl.substring(filePathOrUrl.lastIndexOf(47) + 1);
        return fileName;
    }

    public static boolean support(String filename) {
        String ext = FileUtils.suffix(filename);
        return !ext.isEmpty() && officeTypes.containsKey(ext);
    }

    public static boolean support(Path path) {
        return Optional.ofNullable(path).map(Path::getFileName).map(Path::toString).map(FileUtils::support).orElse(false);
    }

    public static String officeType(String filename) {
        return Optional.of(FileUtils.suffix(filename)).filter(s -> !s.isEmpty()).map(officeTypes::get).orElse("");
    }

    public static String officeType(Path path) {
        return Optional.ofNullable(path).map(Path::getFileName).map(Path::toString).map(FileUtils::officeType).orElse("");
    }

    public static byte[] readAllBytes(Path path) {
        return Files.readAllBytes(path);
    }

    public static long size(Path path) {
        return Files.size(path);
    }

    public static void delete(Path path) {
        Files.delete(path);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    static {
        HashMap map = new HashMap(48);
        Arrays.stream(excelPreviewTypes).forEach(s -> map.put(s, S));
        Arrays.stream(wordPreviewTypes).forEach(s -> map.put(s, W));
        Arrays.stream(powerPointPreviewTypes).forEach(s -> map.put(s, P));
        Arrays.stream(pdfPreviewTypes).forEach(s -> map.put(s, F));
        officeTypes = Collections.unmodifiableMap(map);
    }
}

