/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service.convert.toDoc;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.model.convert.ConvertResponse;
import cn.ljserver.tool.weboffice.v3.model.convert.PdfToDocRequest;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class PdfToDoc {
    public static ConvertResponse convert(String officeType, PdfToDocRequest r) {
        PdfToDoc.checkUrl(officeType, r.getUrl());
        String uri = "/api/developer/v1/office/pdf/convert/to/" + officeType.toLowerCase();
        return ConvertUtils.post(uri, r, ConvertResponse.class);
    }

    public static ConvertResponse convert(String officeType, String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        return PdfToDoc.convert(officeType, new PdfToDocRequest(url));
    }

    private static void checkUrl(String officeType, String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        if (!"pdf".equalsIgnoreCase(FileUtils.suffix(url))) {
            throw new InvalidArgument("url file is not a pdf file !");
        }
        FileUtils.typeMatchCheck(FileUtils.convertToDocumentTypes, officeType);
    }
}

