/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service.convert.docTo;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.model.convert.ConvertResponse;
import cn.ljserver.tool.weboffice.v3.model.convert.OfficeToRequest;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class WordToDocx {
    public static ConvertResponse convert(OfficeToRequest r) {
        WordToDocx.checkUrl(r.getUrl());
        String uri = "/api/developer/v1/office/save/as/docx";
        return ConvertUtils.post(uri, r, ConvertResponse.class);
    }

    public static ConvertResponse convert(String url) {
        return WordToDocx.convert(new OfficeToRequest(url));
    }

    public static ConvertResponse convert(String url, String fileName) {
        return WordToDocx.convert(new OfficeToRequest(url, fileName));
    }

    public static ConvertResponse convert(String url, String fileName, String password) {
        return WordToDocx.convert(new OfficeToRequest(url, fileName, password));
    }

    private static void checkUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        String fileType = FileUtils.suffix(url);
        FileUtils.typeMatchCheck(FileUtils.wordToDocxTypes, fileType);
    }
}

