/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service.convert.docTo;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.model.convert.ConvertResponse;
import cn.ljserver.tool.weboffice.v3.model.convert.DocToTxtRequest;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class DocToTxt {
    public static ConvertResponse convert(DocToTxtRequest r) {
        DocToTxt.checkUrl(r.getUrl());
        String uri = "/api/developer/v1/office/convert/to/txt";
        return ConvertUtils.post(uri, r, ConvertResponse.class);
    }

    public static ConvertResponse convert(String url) {
        return DocToTxt.convert(new DocToTxtRequest(url));
    }

    public static ConvertResponse convert(String url, String fileName) {
        return DocToTxt.convert(new DocToTxtRequest(url, fileName));
    }

    public static ConvertResponse convert(String url, String fileName, String password) {
        return DocToTxt.convert(new DocToTxtRequest(url, fileName, password));
    }

    private static void checkUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        String fileType = FileUtils.suffix(url);
        FileUtils.typeMatchCheck(FileUtils.documentConvertTypes, fileType);
    }
}

