/*
 * Decompiled with CFR 0.152.
 */
package cn.ljserver.tool.weboffice.v3.service.convert.docTo;

import cn.ljserver.tool.weboffice.v3.exception.InvalidArgument;
import cn.ljserver.tool.weboffice.v3.model.convert.ConvertResponse;
import cn.ljserver.tool.weboffice.v3.model.convert.DocToImgRequest;
import cn.ljserver.tool.weboffice.v3.util.ConvertUtils;
import cn.ljserver.tool.weboffice.v3.util.FileUtils;

public class DocToPng {
    public static ConvertResponse convert(DocToImgRequest r) {
        DocToPng.checkUrl(r.getUrl());
        String uri = "/api/developer/v1/office/convert/to/png";
        return ConvertUtils.post(uri, r, ConvertResponse.class);
    }

    public static ConvertResponse convert(String url) {
        return DocToPng.convert(new DocToImgRequest(url));
    }

    public static ConvertResponse convert(String url, String fileName) {
        return DocToPng.convert(new DocToImgRequest(url, fileName));
    }

    public static ConvertResponse convert(String url, String fileName, String password) {
        return DocToPng.convert(new DocToImgRequest(url, fileName, password));
    }

    private static void checkUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new InvalidArgument();
        }
        String fileType = FileUtils.suffix(url);
        FileUtils.typeMatchCheck(FileUtils.documentConvertTypes, fileType);
    }
}

